/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util;

public class ScalerUtil {
    private long mDomainMin;
    private long mDomainMax;
    private long mDomainValue;
    private int mPixelWidth;
    private long mPixelLowerClamp;
    private long mPixelUpperClamp;

    public int getValue() {
        long domainWidth = Math.abs(this.mDomainMax - this.mDomainMin);
        if (domainWidth == 0L) {
            return 0;
        }
        long val = Math.max(this.mDomainValue - this.mDomainMin, 0L) * (long)this.mPixelWidth / domainWidth;
        val = Math.max(val, this.mPixelLowerClamp);
        val = Math.min(val, this.mPixelUpperClamp);
        return (int)val;
    }

    public long getPixelLowerClamp() {
        return this.mPixelLowerClamp;
    }

    public void setPixelLowerClamp(long pixelLowerClamp) {
        this.mPixelLowerClamp = pixelLowerClamp;
    }

    public long getPixelUpperClamp() {
        return this.mPixelUpperClamp;
    }

    public void setPixelUpperClamp(long pixelUpperClamp) {
        this.mPixelUpperClamp = pixelUpperClamp;
    }

    public int getPixelWidth() {
        return this.mPixelWidth;
    }

    public void setPixelWidth(int pixelWidth) {
        this.mPixelWidth = pixelWidth;
    }

    public long getDomainMin() {
        return this.mDomainMin;
    }

    public void setDomainMin(long domainMin) {
        this.mDomainMin = domainMin;
    }

    public long getDomainMax() {
        return this.mDomainMax;
    }

    public void setDomainMax(long domainMax) {
        this.mDomainMax = domainMax;
    }

    public long getDomainValue() {
        return this.mDomainValue;
    }

    public void setDomainValue(long domainValue) {
        this.mDomainValue = domainValue;
    }
}

