/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.util.diff;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SectionSpec {
    private static Pattern pattern = Pattern.compile("@@ *-([0-9]*)(|,([0-9]*)) *(|\\+([0-9]*)(|,([0-9]*))) *@@");
    private int from;
    private int fromCount;
    private int to;
    private int toCount;

    public SectionSpec(String sectionLine) {
        Matcher matcher = pattern.matcher(sectionLine.trim());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Section line [" + sectionLine + "] is not a valid diff section line");
        }
        String fromStr = matcher.group(1);
        String fromCountStr = matcher.group(3);
        String toStr = matcher.group(5);
        String toCountStr = matcher.group(7);
        this.from = Integer.parseInt(fromStr);
        this.fromCount = fromCountStr != null ? Integer.parseInt(fromCountStr) : 1;
        if (toStr == null) {
            this.to = -1;
            this.toCount = -1;
        } else {
            this.to = Integer.parseInt(toStr);
            this.toCount = toCountStr != null ? Integer.parseInt(toCountStr) : 1;
        }
    }

    public int getFrom() {
        return this.from;
    }

    public int getFromCount() {
        return this.fromCount;
    }

    public int getTo() {
        return this.to;
    }

    public int getToCount() {
        return this.toCount;
    }

    public static boolean isValidSection(String sectionLine) {
        return pattern.matcher(sectionLine.trim()).matches();
    }
}

