/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.vis.DrawContextMetrics;
import gnu.trove.TIntHashSet;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

public class DrawContext {
    private static Color[] INTERIOR_COLOURS = new Color[]{new Color(238, 238, 238), new Color(238, 255, 238), new Color(238, 238, 255), new Color(255, 238, 238)};
    private static Color BRANCH_LABEL_COLOUR = new Color(255, 255, 215);
    private static Color DATE_COLOUR = new Color(96, 96, 96);
    private final Graphics2D g;
    private final DrawContextMetrics metrics;
    private final StringBuffer mMap = new StringBuffer();

    public DrawContext(Graphics2D g2, DrawContextMetrics metrics) {
        this.g = g2;
        this.metrics = metrics;
    }

    public void drawNode(FileHistory hist, FileRevision ri, int x, int y, int w) {
        String rev = ri.getRevision();
        String revStr = rev.toString();
        int minWidth = this.metrics.computeWidth(ri);
        int indent = Math.max((w - minWidth) / 2, 0);
        x += indent;
        w = minWidth;
        int h2 = this.metrics.getNodeHeight();
        if (this.g != null) {
            this.g.setColor(Color.BLACK);
            this.g.fillRect(x + 2, y + 2, w, h2);
            this.g.setColor(this.getNodeColour(this.countBranchDepth(hist, ri)));
            this.g.fillRect(x, y, w, h2);
            this.g.setColor(Color.BLACK);
            this.g.drawRect(x, y, w, h2);
            this.g.setColor(Color.BLACK);
            this.drawCenteredString(revStr, x, y + this.metrics.getNodeHeight() / 2, w, this.metrics.getLabelFont());
            this.g.setColor(DATE_COLOUR);
            int lineOffset = 12;
            this.drawCenteredString(this.metrics.formatDate(ri.getDate()), x, y + this.metrics.getNodeHeight() / 2 + lineOffset, w, this.metrics.getDateFont());
        }
        this.drawMapRect("#r" + revStr, revStr, x, y, w, h2);
    }

    private int countBranchDepth(FileHistory hist, FileRevision ri) {
        int depth = 0;
        TIntHashSet visited = new TIntHashSet();
        while (ri != null && !visited.contains(ri.getRevID())) {
            visited.add(ri.getRevID());
            ++depth;
            String br = ri.getBranch();
            String rev = hist.getBranchPoint(br);
            ri = rev == null ? null : hist.getRevision(rev);
        }
        return depth;
    }

    public void drawBranchLabel(String brName, int x, int y, int w) {
        int h2 = this.metrics.getNodeHeight();
        if (this.g != null) {
            int radius = 15;
            this.g.setColor(Color.BLACK);
            this.g.fillRoundRect(x + 2, y + 2, w, h2, radius, radius);
            this.g.setColor(BRANCH_LABEL_COLOUR);
            this.g.fillRoundRect(x, y, w, h2, radius, radius);
            this.g.setColor(Color.BLACK);
            this.g.drawRoundRect(x, y, w, h2, radius, radius);
            this.g.setColor(Color.BLACK);
            this.drawCenteredString(brName, x, y + this.metrics.getNodeHeight() / 2, w, this.metrics.getLabelFont());
        }
        this.drawMapRect("#b" + brName, brName, x, y, w, h2);
    }

    private Color getNodeColour(int depth) {
        int idx = Math.max(0, depth - 1);
        idx = Math.min(idx, INTERIOR_COLOURS.length - 1);
        return INTERIOR_COLOURS[idx];
    }

    public void drawNodeEdge(String r0, int x, int y0, int w, String r1, int y1) {
        x += w / 2;
        y0 += this.metrics.getNodeHeight();
        if (this.g != null) {
            this.g.setColor(Color.BLACK);
            this.g.drawLine(x, y0, x, y1);
        }
    }

    public void drawSkippedNodeEdge(String r0, int x, int y0, int w, String r1, int y1) {
        x += w / 2;
        y0 += this.metrics.getNodeHeight();
        if (this.g != null) {
            this.g.setColor(Color.GRAY);
            int len = 3;
            int step = 6;
            for (int y = y0; y <= y1; y += 6) {
                this.g.drawLine(x, y, x, y + 3);
            }
        }
    }

    public void drawBranchEdge(String bp, int x0, int y0, int w0, String br, int x1, int y1, int w1) {
        x0 += w0;
        y0 += this.metrics.getNodeHeight() / 2;
        x1 += w1 / 2;
        if (this.g != null) {
            this.g.setColor(Color.BLACK);
            this.g.drawLine(x0, y0, x1, y0);
            this.g.drawLine(x1, y0, x1, y1);
        }
    }

    public void drawBackground(int width, int height) {
        if (this.g != null) {
            this.g.setColor(Color.WHITE);
            this.g.fillRect(0, 0, width, height);
        }
    }

    private void drawMapRect(String href, String alt, int x, int y, int w, int h2) {
        this.mMap.append("<area href=\"").append(href).append("\"");
        this.mMap.append(" alt=\"").append(alt).append("\"");
        this.mMap.append(" shape=\"rect\"");
        this.mMap.append(" coords=\"");
        this.mMap.append(x).append(",").append(y).append(",").append(x + w).append(",").append(y + h2);
        this.mMap.append("\">\n");
    }

    private void drawCenteredString(String str, int x, int y, int w, Font font) {
        if (this.g != null) {
            this.g.setFont(font);
            FontMetrics fm = this.g.getFontMetrics(font);
            int xindent = Math.max(0, w - fm.stringWidth(str)) / 2;
            this.g.drawString(str, x + xindent, y);
        }
    }

    public String getImageMap() {
        return this.mMap.toString();
    }
}

