/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.vis;

import com.cenqua.fisheye.vis.LineCountChart;
import com.cenqua.fisheye.vis.LineCountChartUtils;
import com.cenqua.fisheye.vis.StackedXYAreaRenderer2TopLine;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;

public class LineCountChartArea
extends LineCountChart {
    private boolean useToplineRenderer(int seriesCount) {
        return seriesCount < 2;
    }

    XYPlot createLineCountPlot(XYSeriesCollection lineHistory, boolean isMiniChart) {
        StackedXYAreaRenderer2 renderer;
        DefaultTableXYDataset dataset = new DefaultTableXYDataset();
        for (int i2 = 0; i2 < lineHistory.getSeriesCount(); ++i2) {
            dataset.addSeries(lineHistory.getSeries(i2));
        }
        if (this.useToplineRenderer(lineHistory.getSeriesCount())) {
            StackedXYAreaRenderer2TopLine rendererTopline = new StackedXYAreaRenderer2TopLine();
            for (int i3 = 0; i3 < lineHistory.getSeriesCount(); ++i3) {
                rendererTopline.setSeriesPaint(i3, LineCountChartUtils.getToplineColourLight());
                rendererTopline.setSeriesOutlinePaint(i3, LineCountChartUtils.getToplineColourDark());
                rendererTopline.setSeriesOutlineStroke(i3, new BasicStroke(2.0f, 1, 0));
                rendererTopline.setSeriesVisibleInLegend(i3, true);
            }
            renderer = rendererTopline;
        } else {
            renderer = new StackedXYAreaRenderer2();
            renderer.setBaseSeriesVisibleInLegend(false);
            for (int i4 = 0; i4 < lineHistory.getSeriesCount(); ++i4) {
                renderer.setSeriesPaint(i4, LineCountChartUtils.getXYColour(i4));
            }
        }
        renderer.setLegendArea((Shape)new Rectangle(-10, -10, 20, 20));
        XYPlot lcPlot = this.createXYPlot((XYDataset)dataset, null, this.createValueAxis(), (XYItemRenderer)renderer, 6);
        this.addDomainMarker(lcPlot);
        lcPlot.getRangeAxis().setStandardTickUnits(this.getEngineeringTickUnits(lcPlot.getRangeAxis().getUpperBound(), 6));
        return lcPlot;
    }

    XYPlot createCommitHistoryPlot(XYDataset commitHistory, boolean isMiniChart, boolean visibleInLegend) {
        XYPlot volPlot;
        ValueAxis volRangeAxis = this.createValueAxis();
        if (isMiniChart) {
            XYBarRenderer volRenderer = new XYBarRenderer();
            volRenderer.setSeriesPaint(0, (Paint)Color.blue.darker());
            volRenderer.setLegendBar((Shape)new Rectangle(20, 20));
            volPlot = this.createXYPlot(commitHistory, null, volRangeAxis, (XYItemRenderer)volRenderer, 4);
            volPlot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        } else {
            StackedXYBarRenderer volRenderer = new StackedXYBarRenderer();
            volRenderer.setMargin(0.0);
            volRenderer.setLegendBar((Shape)new Rectangle(20, 20));
            if (this.useToplineRenderer(commitHistory.getSeriesCount())) {
                volRenderer.setSeriesPaint(0, LineCountChartUtils.getToplineColourDark());
                volRenderer.setBaseSeriesVisibleInLegend(false);
            } else {
                volRenderer.setBaseSeriesVisibleInLegend(visibleInLegend);
                for (int i2 = 0; i2 < commitHistory.getSeriesCount(); ++i2) {
                    volRenderer.setSeriesPaint(i2, LineCountChartUtils.getXYColour(i2));
                }
            }
            volPlot = this.createXYPlot(commitHistory, null, volRangeAxis, (XYItemRenderer)volRenderer, 4);
        }
        this.addDomainMarker(volPlot);
        return volPlot;
    }
}

