/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.bucket.BucketGraph;
import com.cenqua.fisheye.bucket.CalculatedBucketGraph;
import com.cenqua.fisheye.bucket.CalculatedBucketGraphPie;
import com.cenqua.fisheye.bucket.CalculatedBucketGraphXY;
import com.cenqua.fisheye.bucket.ParameterSetRetrieve;
import com.cenqua.fisheye.bucket.RenamingRules;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.vis.LineCountChart;
import com.cenqua.fisheye.vis.LineCountChartArea;
import com.cenqua.fisheye.vis.LineCountChartLine;
import com.cenqua.fisheye.vis.LineCountChartPie;
import com.cenqua.fisheye.vis.LineCountChartUtils;
import com.cenqua.fisheye.web.BaseAction;
import com.cenqua.fisheye.web.DirTreeFragmentAction;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.RepositoryExplorer;
import com.cenqua.fisheye.web.WaybackSpecChart;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.imagemap.ImageMapUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartPageAction
extends BaseAction {
    private RepositoryEngine engine;
    private static final String PARAM_AUTHOR_HISTORY_CHART = "authorHistoryChart";
    private static final String PARAM_AUTHOR_HISTORY_MAP = "authorHistoryMap";
    protected WaybackSpecChart mWB = new WaybackSpecChart();

    @Override
    public void setup() {
        this.engine = this.getPathInfo().getEngine();
    }

    @Override
    protected void parseWaybackSpec() {
        WaybackSpecChart wbSpec = WaybackSpecChart.fromPathInfo(this.getPathInfo());
        if (wbSpec != null) {
            this.getRequest().setAttribute("wbSpec", (Object)wbSpec);
            this.mWB = wbSpec;
        }
    }

    @Override
    protected boolean handleWaybackJump(String mmodeUrl) throws IOException {
        FishEyePathInfo pi = this.getPathInfo();
        HttpServletRequest req = this.getRequest();
        if (req.getParameter("wbjump") != null) {
            WaybackSpecChart wbSpec = WaybackSpecChart.fromRequest(req);
            String url = req.getContextPath() + mmodeUrl + wbSpec.getUrlCommand() + "/" + ExpressionUtil.urlEncode(pi.getFullPath().getPath());
            this.getResponse().sendRedirect(url);
            return true;
        }
        return false;
    }

    @Override
    public BaseAction handleRequest() throws ServletException, IOException, DbException, RCSParser.ParseException {
        RenamingRules renameRules;
        Path localPath = this.getPathInfo().getLocalPath();
        HttpServletResponse resp = this.getResponse();
        HttpServletRequest req = this.getRequest();
        if (req.getParameter("dirtreefragrender") != null) {
            return new DirTreeFragmentAction("chart");
        }
        if (this.handleWaybackJump("/chart")) {
            return null;
        }
        this.setupWaybackDropdowns();
        this.parseWaybackSpec();
        this.mWB.setupChartDropdowns(localPath, this.engine);
        String branch = this.mWB == null ? null : this.mWB.getBranch();
        List<String> author = this.mWB == null ? null : this.mWB.getAuthors();
        List<String> extn = this.mWB == null ? null : this.mWB.getExtn();
        Integer maxItems = this.mWB == null ? null : this.mWB.getMaxItems();
        RenamingRules renamingRules = renameRules = this.mWB == null ? null : this.mWB.getRenameRules();
        if (branch == null) {
            branch = this.getBranchConstraint(localPath);
        }
        Date date1 = this.mWB == null || this.mWB.getDate1Str() == null ? null : new Date(this.mWB.getDate1());
        Date date2 = this.mWB == null || this.mWB.getDate2Str() == null ? new Date(System.currentTimeMillis()) : new Date(this.mWB.getDate2());
        String authorHistoryChart = req.getParameter(PARAM_AUTHOR_HISTORY_CHART);
        if (authorHistoryChart != null) {
            resp.setContentType(LineCountChartUtils.getImageContentType());
            this.renderAuthorHistoryChart(localPath, author, branch, extn, date1, date2, maxItems, renameRules, true);
        } else {
            req.setAttribute("wbSpec", (Object)this.mWB);
            req.setAttribute("fpath", (Object)this.getPathInfo().getFullPath());
            req.setAttribute("lpath", (Object)this.getPathInfo().getLocalPath());
            req.setAttribute("action", (Object)this);
            req.setAttribute("repository", (Object)new RepositoryExplorer(this.engine, this.getPathInfo().getLocalPath(), this.mWB, this.getUserPreferences()));
            req.setAttribute("showAuthorLinecount", (Object)this.engine.getRevisionCache().showAuthorLinecount());
            req.setAttribute("availableExtns", this.engine.getBucketGraph().getAvailableExtensions(localPath));
            CalculatedBucketGraph graph = this.renderAuthorHistoryChart(localPath, author, branch, extn, date1, date2, maxItems, renameRules, false);
            if (!graph.noGraphData()) {
                String map = ImageMapUtilities.getImageMap((String)PARAM_AUTHOR_HISTORY_MAP, (ChartRenderingInfo)graph.getChartRenderingInfo());
                req.setAttribute(PARAM_AUTHOR_HISTORY_MAP, (Object)map);
            }
            req.setAttribute("noData", (Object)graph.noGraphData());
            this.getRequest().getRequestDispatcher("/WEB-INF/jsp/chart.jsp").forward((ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
        }
        return null;
    }

    private CalculatedBucketGraph renderAuthorHistoryChart(Path localPath, List<String> author, String branch, List<String> extn, Date date1, Date date2, Integer maxItems, RenamingRules renameRules, boolean writeImage) throws DbException, IOException {
        CalculatedBucketGraph graphs;
        int h2;
        int w;
        String width = this.getRequest().getParameter("w");
        try {
            w = width != null ? Integer.parseInt(width) : 700;
        }
        catch (NumberFormatException e2) {
            w = 700;
        }
        String height = this.getRequest().getParameter("h");
        try {
            h2 = height != null ? Integer.parseInt(height) : 400;
        }
        catch (NumberFormatException e3) {
            h2 = 400;
        }
        BucketGraph bucketGraph = this.engine.getBucketGraph();
        ParameterSetRetrieve.BreakdownOption breakdownOption = this.mWB == null ? ParameterSetRetrieve.BreakdownOption.NONE : this.mWB.getBreakdownOption();
        ParameterSetRetrieve params = new ParameterSetRetrieve(localPath, branch, extn, author, breakdownOption, bucketGraph.isCaseSensitive());
        boolean isPie = false;
        String date = "";
        if (this.mWB == null || this.mWB.isArea()) {
            graphs = this.getAreaGraph(bucketGraph, params, w, h2, date1, date2, writeImage, maxItems, renameRules);
        } else if (this.mWB.isLine()) {
            graphs = this.getLineGraph(bucketGraph, params, w, h2, date1, date2, writeImage, maxItems, renameRules);
        } else if (this.mWB.isPie()) {
            graphs = this.getPieGraph(bucketGraph, params, w, h2, date2, writeImage, maxItems, renameRules);
            isPie = true;
            date = ((CalculatedBucketGraphPie)graphs).getDate().toString();
        } else {
            graphs = new CalculatedBucketGraphXY();
        }
        this.getRequest().setAttribute("title", (Object)this.getTitle(localPath, branch, author, extn, breakdownOption, isPie, date));
        return graphs;
    }

    private CalculatedBucketGraph getAreaGraph(BucketGraph bucketGraph, ParameterSetRetrieve params, int w, int h2, Date date1, Date date2, Boolean writeImage, Integer maxItems, RenamingRules renameRules) throws IOException, DbException {
        CalculatedBucketGraphXY graphsXY = bucketGraph.getXYSeries(params, w, date1, date2, false, renameRules, maxItems);
        BufferedImage image = new LineCountChartArea().renderPathHistoryImage(graphsXY, w, h2, null, LineCountChart.getGraphTimeZone(this.getRequest()), false);
        if (writeImage.booleanValue()) {
            ChartUtilities.writeBufferedImageAsPNG((OutputStream)this.getResponse().getOutputStream(), (BufferedImage)image);
        }
        return graphsXY;
    }

    private CalculatedBucketGraph getLineGraph(BucketGraph bucketGraph, ParameterSetRetrieve params, int w, int h2, Date date1, Date date2, Boolean writeImage, Integer maxItems, RenamingRules renameRules) throws IOException, DbException {
        CalculatedBucketGraphXY graphsXY = bucketGraph.getXYSeries(params, w, date1, date2, false, renameRules, maxItems);
        BufferedImage image = new LineCountChartLine().renderPathHistoryImage(graphsXY, w, h2, null, LineCountChart.getGraphTimeZone(this.getRequest()), false);
        if (writeImage.booleanValue()) {
            ChartUtilities.writeBufferedImageAsPNG((OutputStream)this.getResponse().getOutputStream(), (BufferedImage)image);
        }
        return graphsXY;
    }

    private CalculatedBucketGraph getPieGraph(BucketGraph bucketGraph, ParameterSetRetrieve params, int w, int h2, Date date2, Boolean writeImage, Integer maxItems, RenamingRules renameRules) throws IOException, DbException {
        CalculatedBucketGraphPie graphsPie = bucketGraph.getPieData(params, date2, renameRules, maxItems);
        BufferedImage image = new LineCountChartPie().renderPathHistoryImage(graphsPie, w, h2);
        if (writeImage.booleanValue()) {
            ChartUtilities.writeBufferedImageAsPNG((OutputStream)this.getResponse().getOutputStream(), (BufferedImage)image);
        }
        return graphsPie;
    }

    private String getTitle(Path localPath, String branch, List<String> author, List<String> extn, ParameterSetRetrieve.BreakdownOption breakdownOption, boolean isPie, String date) {
        StringBuilder title = new StringBuilder();
        if (isPie) {
            title.append("LOC breakdown at ").append(date).append(" for ");
        } else {
            title.append("LOC and Commit History for ");
        }
        title.append("Path /");
        if (localPath != null) {
            title.append(localPath);
        }
        if (branch != null && !branch.equals("")) {
            title.append(", Branch ").append(branch);
        }
        if (author != null && author.size() != 0 && breakdownOption != ParameterSetRetrieve.BreakdownOption.AUTHOR) {
            title.append(", Author ").append(author);
        }
        if (extn != null && extn.size() != 0 && breakdownOption != ParameterSetRetrieve.BreakdownOption.EXTN) {
            title.append(", File Extension ").append(extn);
        }
        switch (breakdownOption) {
            case AUTHOR: {
                title.append(", Shown by author");
                break;
            }
            case EXTN: {
                title.append(", Shown by file extension");
                break;
            }
            case SUBDIR: {
                title.append(", Shown by subdirectory");
            }
        }
        return title.toString();
    }
}

