/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.web.util.FishEyeURLEncoder;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;

public class CookiePreferences {
    private static final String LAST_MODIFIED_KEY = "D";
    private static final String COOKIE_PREF_DELIM = ";";
    private static final Pref SHOW_LINE_HISTORY = new Pref("showLineHistory", "slh", "Y");
    private static final String DIFFMODE = "diffMode";
    private static final String DIFFWRAP = "diffWrap";
    private static final String DIFFMODE_UNIFIED = "u";
    private static final String DIFFMODE_SIDEBYSIDE = "y";
    private static final String DIFFWRAP_HARD = "h";
    private static final String DIFFWRAP_SOFT = "s";
    private static final String DIFFCOLOUR = "diffColour";
    private static final String DIFFCOLOUR_OLD = "1";
    private static final String DIFFCOLOUR_NEW = "2";
    private static final Pref[] ALL_PREFS = new Pref[]{new Pref("longTagList", "ltl", "M"), new Pref("showFileHistImage", "sfhi", "Y"), new Pref("showAuthorChart", "sac", "Y"), new Pref("showQuickRecent", "sqr", "Y"), new Pref("annotateMode", "annm", "age"), new Pref("dirListOrder", "dlo", "p"), new Pref("csShowDiffs", "csSD", "false"), new Pref("csTruncateDiffs", "csTD", "true"), new Pref("hideHiddenDirectories", "hhd", "Y"), new Pref("hideEmptyDirectories", "hed", "N"), new Pref("hideDeletedFiles", "hdf", "N"), new Pref("viewMode", "hvm", "p"), new Pref("diffColour", "dc", "2"), new Pref("diffMode", "dm", "u"), new Pref("diffWrap", "dw", "h"), SHOW_LINE_HISTORY};
    private static final Map CNAME_TO_PNAME = new HashMap();
    private static final Map PREF_MAP = new HashMap();
    private static final Map DEFAULT_PREFS = new HashMap();
    private boolean mChanged = false;
    private Map defaultPrefs = DEFAULT_PREFS;
    private Map mCustomPrefs = null;
    private Map mMapValue = null;
    private Long mLastModified = null;

    private CookiePreferences(Cookie cookie) {
        this(cookie.getValue());
    }

    private CookiePreferences(String cookieStr) {
        if (cookieStr.trim().length() == 0) {
            return;
        }
        try {
            cookieStr = URLDecoder.decode(cookieStr, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            Logs.APP_LOG.debug((Object)("UTF-8 not supported. " + e2));
        }
        StringTokenizer toks = new StringTokenizer(cookieStr, COOKIE_PREF_DELIM, false);
        while (toks.hasMoreTokens()) {
            String tok = toks.nextToken();
            int i2 = tok.indexOf(61);
            if (i2 < 1) {
                this.mChanged = true;
                continue;
            }
            String cname = tok.substring(0, i2);
            int j = Math.min(i2 + 1, tok.length() - 1);
            String val = tok.substring(j, tok.length());
            if (cname.equals(LAST_MODIFIED_KEY)) {
                try {
                    this.mLastModified = Long.valueOf(val);
                }
                catch (NumberFormatException e3) {
                    Logs.APP_LOG.warn((Object)("funny date value: " + val));
                }
                continue;
            }
            String pname = CookiePreferences.cnameToPname(cname);
            if (pname == null) {
                this.mChanged = true;
                continue;
            }
            if (!this.setValueImpl(pname, val)) continue;
            this.mChanged = true;
        }
        if (this.mChanged) {
            this.mLastModified = System.currentTimeMillis();
        }
    }

    public static CookiePreferences fromCookie(Cookie cookie) {
        return new CookiePreferences(cookie);
    }

    public static CookiePreferences fromString(String cookieStr) {
        return new CookiePreferences(cookieStr);
    }

    public static void toDb(UserLogin user, CookiePreferences up) {
    }

    public Long getLastModified() {
        return this.mLastModified;
    }

    public CookiePreferences() {
    }

    public String asCookieValue() {
        StringBuffer buf = new StringBuffer();
        buf.append(LAST_MODIFIED_KEY).append("=").append(System.currentTimeMillis());
        if (this.mCustomPrefs != null) {
            String sep = COOKIE_PREF_DELIM;
            for (String pname : this.mCustomPrefs.keySet()) {
                String val = (String)this.mCustomPrefs.get(pname);
                String cname = this.pnameToCname(pname);
                buf.append(sep);
                buf.append(cname).append("=").append(val);
                sep = COOKIE_PREF_DELIM;
            }
        }
        return FishEyeURLEncoder.encode(buf.toString());
    }

    public Map getMap() {
        if (this.mMapValue == null) {
            this.mMapValue = new HashMap(this.defaultPrefs);
            if (this.mCustomPrefs != null) {
                this.mMapValue.putAll(this.mCustomPrefs);
            }
        }
        return this.mMapValue;
    }

    public String getPreference(String name) {
        return (String)this.getMap().get(name);
    }

    private boolean setValueImpl(String pname, String val) {
        this.mMapValue = null;
        String def = CookiePreferences.getDefault(pname);
        if (val.equals(def)) {
            if (this.mCustomPrefs != null) {
                this.mCustomPrefs.remove(pname);
            }
            return true;
        }
        if (this.mCustomPrefs == null) {
            this.mCustomPrefs = new HashMap();
        }
        this.mCustomPrefs.put(pname, val);
        return false;
    }

    public void setValue(String param, String val) {
        this.setValueImpl(param, val);
        this.mChanged = true;
    }

    public boolean isChanged() {
        return this.mChanged;
    }

    public boolean isSideBySide() {
        return DIFFMODE_SIDEBYSIDE.equals(this.getPreference(DIFFMODE));
    }

    public boolean isSoftWrap() {
        return DIFFWRAP_SOFT.equals(this.getPreference(DIFFWRAP));
    }

    public boolean isOldDiffColour() {
        return DIFFCOLOUR_OLD.equals(this.getPreference(DIFFCOLOUR));
    }

    private static String getDefault(String pname) {
        Pref pref = (Pref)PREF_MAP.get(pname);
        if (pref != null) {
            return pref.defaultValue;
        }
        return "";
    }

    private static String cnameToPname(String cname) {
        return (String)CNAME_TO_PNAME.get(cname);
    }

    private String pnameToCname(String pname) {
        Pref pref = (Pref)PREF_MAP.get(pname);
        if (pref != null) {
            return pref.cookieName;
        }
        return "UNKNOWN";
    }

    static {
        for (int i2 = 0; i2 < ALL_PREFS.length; ++i2) {
            Pref pref = ALL_PREFS[i2];
            CNAME_TO_PNAME.put(pref.cookieName, pref.name);
            PREF_MAP.put(pref.name, pref);
            DEFAULT_PREFS.put(pref.name, pref.defaultValue);
        }
    }

    static class Pref {
        final String name;
        final String cookieName;
        final String defaultValue;

        public Pref(String name, String cookieName, String defaultValue) {
            this.name = name;
            this.cookieName = cookieName;
            this.defaultValue = defaultValue;
        }
    }
}

