/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.DateHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class JspUtils {
    public String formatDate(long aDate, String format) {
        SimpleDateFormat fmt = new SimpleDateFormat(format, Locale.US);
        return fmt.format(new Date(aDate));
    }

    public long getNow() {
        return System.currentTimeMillis();
    }

    public Date getNowValue() {
        return new Date(this.getNow());
    }

    public List range(int start, int end) {
        int len = end - start;
        ArrayList<Integer> list = new ArrayList<Integer>(len);
        for (int i2 = 0; i2 < len; ++i2) {
            list.add(i2 + start);
        }
        return list;
    }

    public String age(long birth, long now) {
        return DateHelper.age(birth, now);
    }

    public boolean isLoginPossible() {
        UserManager um = AppConfig.getsConfig().getUserManager();
        try {
            return um.isLoginPossible();
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"problem", (Throwable)e2);
            return true;
        }
    }

    public boolean isSignupAllowed() {
        SecurityType securityConfig = AppConfig.getsConfig().getConfig().getSecurity();
        return securityConfig.getBuiltIn().getSignup().getEnabled();
    }
}

