/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.CookiePreferences;
import com.cenqua.fisheye.web.UserProfile;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PreferenceManager {
    private static final String PREF_COOKIE_NAME = "crucibleprefs1";
    private static final String ATTRIBUTE_NAME = "userPrefs";
    private static final int COOKIE_AGE = 31536000;

    public static CookiePreferences getPreferences(HttpServletRequest req) {
        CookiePreferences prefs = (CookiePreferences)req.getAttribute(ATTRIBUTE_NAME);
        if (prefs == null) {
            prefs = PreferenceManager.loadUserPreference(req);
        }
        return prefs;
    }

    public static CookiePreferences loadUserPreference(HttpServletRequest req) {
        Cookie[] cookies;
        CookiePreferences prefs = null;
        UserManager um = AppConfig.getsConfig().getUserManager();
        UserLogin user = um.getCurrentUser(req);
        if (user != null) {
            try {
                UserProfile prof = AppConfig.getsConfig().getUserProfileManager().getProfile(user.getUsername());
                if (prof != null) {
                    prefs = CookiePreferences.fromString(prof.getCookiePrefs());
                }
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)"error reading profile from database", (Throwable)e2);
            }
        }
        if (prefs == null && (cookies = req.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                if (!PREF_COOKIE_NAME.equals(cookie.getName())) continue;
                prefs = CookiePreferences.fromCookie(cookie);
                break;
            }
        }
        if (prefs == null) {
            prefs = new CookiePreferences();
        }
        req.setAttribute(ATTRIBUTE_NAME, (Object)prefs);
        return prefs;
    }

    public static void doFilter(HttpServletRequest req, HttpServletResponse resp) {
        CookiePreferences up = PreferenceManager.getPreferences(req);
        Enumeration pnames = req.getParameterNames();
        while (pnames.hasMoreElements()) {
            String param = (String)pnames.nextElement();
            if (!param.startsWith("@")) continue;
            String val = req.getParameter(param);
            up.setValue(param.substring(1), val);
        }
        if (up.isChanged()) {
            PreferenceManager.writeCookie(up, req, resp);
        }
    }

    public static void touchCookie(HttpServletRequest req, HttpServletResponse resp) {
        PreferenceManager.writeCookie(PreferenceManager.getPreferences(req), req, resp);
    }

    private static void writeCookie(CookiePreferences cp, HttpServletRequest req, HttpServletResponse resp) {
        String val = cp.asCookieValue();
        Cookie cookie = PreferenceManager.makeCookie(req, val);
        if (val.length() == 0) {
            cookie.setMaxAge(0);
        }
        resp.addCookie(cookie);
        UserManager um = AppConfig.getsConfig().getUserManager();
        UserLogin user = um.getCurrentUser(req);
        if (user != null) {
            try {
                UserProfile prof = AppConfig.getsConfig().getUserProfileManager().getProfile(user.getUsername());
                if (prof != null) {
                    prof.setCookiePrefs(val);
                    AppConfig.getsConfig().getUserProfileManager().setProfile(user.getUsername(), prof);
                }
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)"error writing profile to database", (Throwable)e2);
            }
        }
    }

    private static Cookie makeCookie(HttpServletRequest req, String val) {
        Cookie cookie = new Cookie(PREF_COOKIE_NAME, val);
        String ctxPath = req.getContextPath();
        if (ctxPath.length() == 0) {
            ctxPath = "/";
        }
        cookie.setPath(ctxPath);
        cookie.setMaxAge(31536000);
        Logs.APP_LOG.debug((Object)("adding cookie " + ctxPath + " str=" + cookie.getValue()));
        return cookie;
    }
}

