/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.logging.Logs;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.util.UrlEncoded;

public class ServletUtils {
    public static final String ORIG_REQUEST_URI = "fisheye.forward.request_uri";
    public static final String ORIG_CONTEXT_PATH = "fisheye.forward.context_path";
    public static final String ORIG_QUERY_STRING = "fisheye.forward.query_string";

    public static void send404(HttpServletRequest request, HttpServletResponse response, String msg) throws IOException {
        Logs.APP_LOG.info((Object)("404: " + msg + " referer=" + request.getHeader("Referer")));
        response.sendError(404, msg);
    }

    public static String getPostContextPath(HttpServletRequest req) {
        String cp;
        String uri = ServletUtils.decodeString(req.getRequestURI());
        String result = uri.substring((cp = ServletUtils.decodeString(req.getContextPath())).length());
        if (!result.startsWith("/")) {
            result = "/" + result;
        }
        return result;
    }

    public static String getOriginalPostContextPath(HttpServletRequest req) {
        String cp;
        String uri = ServletUtils.decodeString(ServletUtils.getOriginalRequestURI(req));
        String result = uri.substring((cp = ServletUtils.decodeString(ServletUtils.getOriginalContextPath(req))).length());
        if (!result.startsWith("/")) {
            result = "/" + result;
        }
        return result;
    }

    public static String getOriginalContextPath(HttpServletRequest req) {
        String cp = (String)req.getAttribute(ORIG_CONTEXT_PATH);
        return cp == null ? req.getContextPath() : cp;
    }

    public static String getOriginalRequestURIAndQueryString(HttpServletRequest req) {
        String qs = ServletUtils.getOriginalQueryString(req);
        return ServletUtils.getOriginalRequestURI(req) + (qs == null ? "" : "?" + qs);
    }

    public static String getOriginalRequestURI(HttpServletRequest req) {
        String uri = (String)req.getAttribute(ORIG_REQUEST_URI);
        return uri == null ? req.getRequestURI() : uri;
    }

    public static String getOriginalQueryString(HttpServletRequest req) {
        String qs = (String)req.getAttribute(ORIG_QUERY_STRING);
        return qs == null ? req.getQueryString() : qs;
    }

    private static String decodeString(String s) {
        return s == null ? "" : UrlEncoded.decodeString((String)s, (int)0, (int)s.length(), (String)"UTF-8");
    }
}

