/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.Ajp13ServerType;
import com.cenqua.fisheye.config1.HttpServerType;
import com.cenqua.fisheye.config1.WebServerType;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.io.ZipHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.jetty.FishEyeWebApplicationContext;
import com.cenqua.fisheye.web.jetty.JspRenderer;
import com.cenqua.fisheye.web.jetty.ProxyPassingSelectChannelConnector;
import com.cenqua.fisheye.web.util.InetAddrPort;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.LocalConnector;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.ajp.Ajp13SocketConnector;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.thread.BoundedThreadPool;
import org.mortbay.thread.ThreadPool;

public class WebServer {
    private final Server mServer;
    private final List desc = new ArrayList();
    private final FishEyeWebApplicationContext webapp;
    private final LocalConnector jspConnector = new LocalConnector();

    public WebServer() throws IOException {
        RootConfig rootConfig = AppConfig.getsConfig();
        WebServerType wsConfig = rootConfig.getConfig().getWebServer();
        String webcontext = "/";
        this.mServer = new Server();
        BoundedThreadPool threadPool = new BoundedThreadPool();
        threadPool.setMaxThreads(wsConfig.getMaxThreads().intValue());
        threadPool.setMinThreads(wsConfig.getMinThreads().intValue());
        this.mServer.setThreadPool((ThreadPool)threadPool);
        if (wsConfig.isSetContext()) {
            webcontext = WebServer.cleanWebContext(wsConfig.getContext());
        }
        this.mServer.addConnector((Connector)this.jspConnector);
        if (wsConfig.isSetHttp()) {
            this.addHTTPListener(wsConfig.getHttp());
        }
        if (wsConfig.isSetAjp13()) {
            this.addAJP13Listener(wsConfig.getAjp13());
        }
        HandlerCollection handlers = new HandlerCollection();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        handlers.setHandlers(new Handler[]{contexts, new DefaultHandler(), requestLogHandler});
        this.mServer.setHandler((Handler)handlers);
        this.webapp = new FishEyeWebApplicationContext((HandlerCollection)contexts, AppConfig.getWebAppLocation().getPath(), webcontext);
        File inst = AppConfig.getInstanceDir().getCanonicalFile();
        File home = AppConfig.getAppHome().getCanonicalFile();
        if (!inst.equals(home)) {
            File source = new File(inst, "content");
            source = source.getCanonicalFile();
            Logs.APP_LOG.info((Object)("Adding secondary content dir of " + source));
            this.webapp.setCustomContentDir(source);
        }
        File tmpDir = new File(AppConfig.getTempDir(), "web");
        tmpDir.mkdirs();
        WebServer.extractPrecompiledClasses(tmpDir);
        this.webapp.setTempDirectory(tmpDir);
        this.webapp.getServletHandler().setFilterChainsCached(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractPrecompiledClasses(File destDir) throws IOException {
        File zip = WebServer.getJspPrecompZip();
        if (!zip.isFile()) {
            return;
        }
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(zip));
            int count = ZipHelper.unzip(in, destDir, false);
            if (count != 0) {
                Logs.APP_LOG.info((Object)("Extracted " + count + " pre-compiled jsp classes to " + destDir));
            }
        }
        catch (Throwable throwable) {
            IOHelper.close(in);
            throw throwable;
        }
        IOHelper.close(in);
    }

    private static File getJspPrecompZip() {
        return new File(AppConfig.getAppHome(), "lib/jsp_pre.zip");
    }

    private void addAJP13Listener(Ajp13ServerType ajp) throws UnknownHostException {
        Ajp13SocketConnector connector = new Ajp13SocketConnector();
        this.setBind((Connector)connector, ajp.getBind());
        this.mServer.addConnector((Connector)connector);
        this.desc.add(ajp.getBind() + " (ajp13)");
    }

    private void addHTTPListener(HttpServerType http) throws UnknownHostException {
        int proxyPort = -1;
        String proxyHost = null;
        String proxyScheme = null;
        if (http.isSetProxyHost()) {
            proxyHost = http.getProxyHost();
        }
        if (http.isSetProxyPort()) {
            proxyPort = http.getProxyPort().intValue();
        }
        if (http.isSetProxyScheme()) {
            proxyScheme = http.getProxyScheme();
        }
        ProxyPassingSelectChannelConnector connector = new ProxyPassingSelectChannelConnector(proxyScheme, proxyHost, proxyPort);
        this.setBind((Connector)connector, http.getBind());
        this.mServer.addConnector((Connector)connector);
        this.desc.add(http.getBind() + " (http)");
    }

    private void setBind(Connector connector, String bindSpec) throws UnknownHostException {
        InetAddrPort bind = new InetAddrPort(bindSpec);
        if (!bind.getHost().equals("0.0.0.0")) {
            connector.setHost(bind.getHost());
        }
        connector.setPort(bind.getPort());
    }

    public void start() throws Exception {
        this.mServer.start();
    }

    public void stop() {
        try {
            this.mServer.stop();
        }
        catch (Exception e2) {
            Logs.APP_LOG.info((Object)"problem closing webserver", (Throwable)e2);
        }
    }

    public void flushContentAndJsps() throws IOException {
        File tmp = this.webapp.getTempDirectory();
        IOHelper.recursiveDelete(tmp, 20, false);
        WebServer.extractPrecompiledClasses(tmp);
    }

    private static String cleanWebContext(String ctx) {
        if (ctx.endsWith("*")) {
            ctx = ctx.substring(0, ctx.length() - 1);
        }
        if (ctx.endsWith("/")) {
            ctx = ctx.substring(0, ctx.length() - 1);
        }
        if (ctx.equals("")) {
            return "/";
        }
        if (!ctx.startsWith("/")) {
            ctx = "/" + ctx;
        }
        return ctx;
    }

    public String getDesc() {
        return StringUtil.join(this.desc, ", ");
    }

    public File getCustomContentDir() {
        return this.webapp.getCustomContentDir();
    }

    public File getTempDir() {
        return this.webapp.getTempDirectory();
    }

    public JspRenderer makeJspRenderer() {
        return new JspRenderer(this.webapp, this.jspConnector);
    }
}

