/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.web.admin.actions.BaseRepositoryAction;

public abstract class AbstractEditAllowAction
extends BaseRepositoryAction {
    public String execute() throws Exception {
        if (this.setOrGet(false)) {
            return "success";
        }
        return "error";
    }

    public String doDefault() throws Exception {
        if (this.setOrGet(true)) {
            return "success";
        }
        return "error";
    }

    private boolean setOrGet(boolean get) throws Exception {
        ConfigDocument.Config cfg = this.getCfg();
        AllowType allow = null;
        if (this.isDefault()) {
            allow = cfg.getRepositoryDefaults().getAllow();
        } else {
            try {
                allow = cfg.getRepositoryArray(this.getRep()).getAllow();
            }
            catch (IndexOutOfBoundsException e2) {
                this.addActionError("Bad repository index " + this.getRep());
                return false;
            }
        }
        try {
            if (get) {
                this.loadAllow(allow);
            } else {
                this.saveAllow(allow);
                this.saveCfg();
            }
        }
        catch (IndexOutOfBoundsException e3) {
            this.addActionError("Bad allow index " + this.getIdx() + ", rep=" + this.getRep());
            return false;
        }
        return true;
    }

    protected abstract void loadAllow(AllowType var1);

    protected abstract void saveAllow(AllowType var1);
}

