/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.LinkerType;
import com.cenqua.fisheye.web.admin.actions.AbstractLinkerAction;

public abstract class AbstractEditLinkerAction
extends AbstractLinkerAction {
    public String execute() throws Exception {
        if (this.setOrGet(false)) {
            return "success";
        }
        return "error";
    }

    public String doDefault() throws Exception {
        if (this.setOrGet(true)) {
            return "success";
        }
        return "error";
    }

    private boolean setOrGet(boolean get) throws Exception {
        ConfigDocument.Config cfg = this.getCfg();
        LinkerType linker = null;
        if (this.isDefault()) {
            linker = cfg.getRepositoryDefaults().getLinker();
        } else {
            try {
                linker = cfg.getRepositoryArray(this.getRep()).getLinker();
            }
            catch (IndexOutOfBoundsException e2) {
                this.addActionError("Bad repository index " + this.getRep());
                return false;
            }
        }
        try {
            if (get) {
                this.loadLinker(linker);
            } else {
                this.saveLinker(linker);
                this.updateLinkers();
            }
        }
        catch (IndexOutOfBoundsException e3) {
            this.addActionError("Bad linker index " + this.getIdx() + ", rep=" + this.getRep());
            return false;
        }
        return true;
    }

    protected abstract void loadLinker(LinkerType var1);

    protected abstract void saveLinker(LinkerType var1);
}

