/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigUtil;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.XmlbeansUtil;
import com.cenqua.fisheye.web.admin.actions.BaseEditRepositoryAction;

public class AddRepositoryAction
extends BaseEditRepositoryAction {
    private boolean enableNow = true;
    private static final int REPO_INDENT = 2;
    private static final int REPO_CHILD_INDENT = 6;
    protected String repoTypeSelection = "CVS";

    public boolean isEnableNow() {
        return this.enableNow;
    }

    public void setEnableNow(boolean enableNow) {
        this.enableNow = enableNow;
    }

    public String doDefault() throws Exception {
        this.svnSymbolic.setupType1();
        return super.doDefault();
    }

    public String execute() throws Exception {
        if (this.testSymbolic != null) {
            RepositoryType currentRepository = (RepositoryType)this.repository.copy();
            if (this.getRepoTypeSelection().equals("CVS")) {
                currentRepository.setCvs(this.cvs);
            } else if (this.getRepoTypeSelection().equals("SVN")) {
                this.svn.setSymbolic(this.svnSymbolic.toXmlBean());
                currentRepository.setSvn(this.svn);
            } else if (this.getRepoTypeSelection().equals("P4")) {
                currentRepository.setPerforce(this.p4);
            }
            this.testSymbolic(currentRepository);
            return "input";
        }
        ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
        this.rep = cfg.getRepositoryArray().length;
        cfg.insertNewRepository(this.rep);
        cfg.setRepositoryArray(this.rep, this.repository);
        RepositoryType currentRepository = cfg.getRepositoryArray(this.rep);
        if (this.getRepoTypeSelection().equals("CVS")) {
            currentRepository.setCvs(this.cvs);
            XmlbeansUtil.placeOnNewLine(currentRepository.getCvs(), 6);
        } else if (this.getRepoTypeSelection().equals("SVN")) {
            this.svn.setSymbolic(this.svnSymbolic.toXmlBean());
            currentRepository.setSvn(this.svn);
            XmlbeansUtil.placeOnNewLine(currentRepository.getSvn(), 6);
        } else if (this.getRepoTypeSelection().equals("P4")) {
            currentRepository.setPerforce(this.p4);
            XmlbeansUtil.placeOnNewLine(currentRepository.getPerforce(), 6);
        }
        currentRepository.setEnabled(this.enableNow);
        XmlbeansUtil.placeOnNewLine(currentRepository, 2);
        AppConfig.getsConfig().saveConfig();
        RepositoryManager rm = AppConfig.getsConfig().getRepositoryManager();
        rm.reloadList();
        if (this.enableNow) {
            try {
                rm.runRepository(this.repository.getName());
            }
            catch (Exception e2) {
                this.addActionError("A problem occurred starting your repository: " + e2.getMessage() + " (" + e2.getClass().getName() + ")");
                Logs.APP_LOG.warn((Object)"problem starting/stopping repository", (Throwable)e2);
                return "error";
            }
        }
        return "success";
    }

    public void validate() {
        this.svnSymbolic.setup();
        super.validate();
        if (this.hasErrors()) {
            return;
        }
        if (this.getRepoTypeSelection().equals("CVS")) {
            this.validateForCVS();
        } else if (this.getRepoTypeSelection().equals("SVN")) {
            this.validateForSVN();
        } else if (this.getRepoTypeSelection().equals("P4")) {
            this.validateForP4();
        }
        if (!this.repository.xgetName().validate()) {
            this.addFieldError("repository.name", "Repository name must match the regex [a-zA-Z0-9_]+");
        }
        if (ConfigUtil.getConfiguredRepNames().contains(this.repository.getName())) {
            this.addFieldError("repository.name", "A repository named \"" + this.repository.getName() + "\" is already defined.");
        }
    }

    public boolean isSvnClientAvailable() {
        boolean svnConfigured;
        try {
            Class.forName("org.tigris.subversion.javahl.SVNClient");
            svnConfigured = true;
        }
        catch (Throwable e2) {
            Logs.APP_LOG.info((Object)("Could not load SVN Client. " + e2.getMessage()), e2);
            svnConfigured = false;
        }
        return svnConfigured;
    }

    public void setRepoTypeSelection(String type) {
        this.repoTypeSelection = type;
    }

    public String getRepoTypeSelection() {
        return this.repoTypeSelection;
    }
}

