/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.license.LicenseInfo;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.user.GroupInfo;
import com.cenqua.fisheye.user.UserManager;
import com.opensymphony.xwork.ActionSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseAdminAction
extends ActionSupport {
    private Map<String, GroupInfo> groupInfos;

    public LicenseInfo getLicense() {
        return AppConfig.getsConfig().getLicense();
    }

    public Map<String, RepositoryHandle> getRepHandleMap() {
        return AppConfig.getsConfig().getRepositoryManager().getHandleMap();
    }

    public Collection<GroupInfo> getGroupInfos() {
        return this.getGroupInfoMap().values();
    }

    public Map<String, GroupInfo> getGroupInfoMap() {
        if (this.groupInfos == null) {
            UserManager um = BaseAdminAction.getUserManager();
            try {
                this.groupInfos = um.getGroupInfos();
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)"Problem getting groups", (Throwable)e2);
                this.groupInfos = Collections.emptyMap();
            }
        }
        return this.groupInfos;
    }

    public Collection<String> getGroupNames() {
        return this.getGroupInfoMap().keySet();
    }

    protected static UserManager getUserManager() {
        return AppConfig.getsConfig().getUserManager();
    }
}

