/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.CvsRepType;
import com.cenqua.fisheye.config1.P4RepType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.SvnRepType;
import com.cenqua.fisheye.cvsrep.CvsRepositoryConfig;
import com.cenqua.fisheye.perforce.P4RepositoryConfig;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.svn.lucene.SvnConstants;
import com.cenqua.fisheye.util.Interval;
import com.cenqua.fisheye.web.admin.actions.BaseAdminAction;
import com.cenqua.fisheye.web.admin.actions.ImportTypeHelper;
import com.cenqua.fisheye.web.admin.actions.svn.SvnSymbolicHelper;
import java.io.File;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class BaseEditRepositoryAction
extends BaseAdminAction {
    protected RepositoryType repository = RepositoryType.Factory.newInstance();
    protected CvsRepType cvs = CvsRepType.Factory.newInstance();
    protected SvnRepType svn = SvnRepType.Factory.newInstance();
    protected P4RepType p4 = P4RepType.Factory.newInstance();
    protected SvnSymbolicHelper svnSymbolic;
    protected ImportTypeHelper importType;
    protected int rep;
    protected String testPath;
    protected String containerId;
    protected String logicalPath;
    protected String logicalTail;
    protected String testSymbolic;

    public BaseEditRepositoryAction() {
        this.repository.setStoreDiff(true);
        this.svn.addNewAuth();
        this.p4.addNewAuth();
        this.p4.setCasesensitive(true);
        this.p4.setPath("//depot/");
        this.svnSymbolic = new SvnSymbolicHelper();
        this.importType = new ImportTypeHelper();
        this.testSymbolic = null;
    }

    public RepositoryType getRepository() {
        return this.repository;
    }

    public CvsRepType getCvs() {
        return this.cvs;
    }

    public SvnRepType getSvn() {
        return this.svn;
    }

    public P4RepType getP4() {
        return this.p4;
    }

    public int getRep() {
        return this.rep;
    }

    public void setRep(int rep) {
        this.rep = rep;
    }

    public SvnSymbolicHelper getSvnSymbolic() {
        return this.svnSymbolic;
    }

    public ImportTypeHelper getImportType() {
        return this.importType;
    }

    public Map getAvailableCharsetsCvs() {
        return this.getAvailableCharsets(CvsRepositoryConfig.DEFAULT_CVS_ENCODING);
    }

    public Map getAvailableCharsetsSvn() {
        return this.getAvailableCharsets(SvnConstants.DEFAULT_SVN_ENCODING);
    }

    public Map getAvailableCharsetsP4() {
        return this.getAvailableCharsets(P4RepositoryConfig.DEFAULT_ENCODING);
    }

    public Map getAvailableCharsets(Charset defaultEncoding) {
        Set<String> builtin = Charset.availableCharsets().keySet();
        LinkedHashMap<String, String> charsets = new LinkedHashMap<String, String>();
        charsets.put("", "default (" + defaultEncoding.name() + ")");
        for (String cs : builtin) {
            charsets.put(cs, cs);
        }
        return charsets;
    }

    public Map getSupportedRepos() {
        LinkedHashMap<String, String> repos = new LinkedHashMap<String, String>();
        repos.put("CVS", "Concurrent Versions System (CVS)");
        repos.put("SVN", "Subversion");
        repos.put("P4", "Perforce");
        return repos;
    }

    protected void validateForCVS() {
        if (BaseEditRepositoryAction.nullOrEmpty(this.cvs.getDir())) {
            this.addFieldError("cvs.dir", "You must specify a CVS directory.");
            return;
        }
        File verify = new File(this.cvs.getDir());
        if (!verify.exists()) {
            this.addFieldError("cvs.dir", "The path \"" + this.cvs.getDir() + "\" doesn't appear to exist.");
        } else if (!verify.isDirectory()) {
            this.addFieldError("cvs.dir", "The path \"" + this.cvs.getDir() + "\" doesn't appear to be a directory.");
        }
        String cs = this.cvs.getCharset();
        if (this.cvs.isSetCharset() && BaseEditRepositoryAction.nullOrEmpty(cs)) {
            this.cvs.unsetCharset();
        }
    }

    protected void validateForP4() {
        if (this.p4.isSetAuth()) {
            if (this.p4.isSetAuth() && BaseEditRepositoryAction.nullOrEmpty(this.p4.getAuth().getUsername()) && BaseEditRepositoryAction.nullOrEmpty(this.p4.getAuth().getPassword())) {
                this.p4.unsetAuth();
            } else if (this.p4.getAuth().isSetPassword() && BaseEditRepositoryAction.nullOrEmpty(this.p4.getAuth().getPassword())) {
                this.p4.getAuth().unsetPassword();
            }
        }
        if (BaseEditRepositoryAction.nullOrEmpty(this.p4.getServer())) {
            this.addFieldError("p4.server", "You must specify a Perforce Server.");
        }
        if (BaseEditRepositoryAction.nullOrEmpty(this.p4.getPath())) {
            this.addFieldError("p4.path", "You must specify the path (at least the depot)");
        }
        if (this.p4.isSetBlocksize() && this.p4.getBlocksize() == null) {
            this.p4.unsetBlocksize();
        } else if (this.p4.isSetBlocksize() && this.p4.getBlocksize().compareTo(BigInteger.ZERO) < 0) {
            this.addFieldError("p4.blocksize", "Block size must be positive.");
        }
        if (this.p4.isSetFileloglimit() && this.p4.getFileloglimit() == null) {
            this.p4.unsetFileloglimit();
        } else if (this.p4.isSetFileloglimit() && this.p4.getFileloglimit().compareTo(BigInteger.ZERO) < 0) {
            this.addFieldError("p4.fileloglimit", "Filelog limit must be positive.");
        }
        if (this.p4.isSetCps() && this.p4.getCps() == 0.0f) {
            this.p4.unsetCps();
        } else if (this.p4.isSetCps() && this.p4.getCps() < 0.0f) {
            this.addFieldError("p4.cps", "CPS must be positive.");
        }
        if (this.p4.isSetPort() && this.p4.getPort() == null) {
            this.p4.unsetPort();
        } else if (this.p4.isSetPort() && this.p4.getPort().signum() < 0) {
            this.addFieldError("p4.port", "Server port must be positive.");
        }
        String cs = this.p4.getCharset();
        if (this.p4.isSetCharset() && BaseEditRepositoryAction.nullOrEmpty(cs)) {
            this.p4.unsetCharset();
        }
        if (this.p4.isSetCommandTimeout() && BaseEditRepositoryAction.nullOrEmpty(this.p4.getCommandTimeout())) {
            this.p4.unsetCommandTimeout();
        } else {
            try {
                new Interval(this.p4.getCommandTimeout(), 1);
            }
            catch (NumberFormatException e2) {
                this.addFieldError("p4.commandTimeout", "Command timeout is not a valid time interval");
            }
        }
    }

    protected void validateForSVN() {
        if (this.svn.isSetAuth() && this.svn.isSetAuth() && BaseEditRepositoryAction.nullOrEmpty(this.svn.getAuth().getUsername()) && BaseEditRepositoryAction.nullOrEmpty(this.svn.getAuth().getPassword())) {
            this.svn.unsetAuth();
        }
        if (BaseEditRepositoryAction.nullOrEmpty(this.svn.getUrl())) {
            this.addFieldError("svn.url", "You must specify a SVN URL.");
            return;
        }
        if (BaseEditRepositoryAction.nullOrEmpty(this.svn.getPath())) {
            this.svn.setPath("");
        }
        if (this.svn.isSetAccess() && BaseEditRepositoryAction.nullOrEmpty(this.svn.getAccess())) {
            this.svn.unsetAccess();
        }
        if (this.svn.isSetBlocksize() && this.svn.getBlocksize() == null) {
            this.svn.unsetBlocksize();
        } else if (this.svn.isSetBlocksize() && this.svn.getBlocksize().compareTo(BigInteger.ZERO) < 0) {
            this.addFieldError("svn.blocksize", "Block size must be positive.");
            return;
        }
        if (this.svn.isSetStartRev() && this.svn.getStartRev() == null) {
            this.svn.unsetStartRev();
        } else if (this.svn.isSetStartRev() && this.svn.getStartRev().compareTo(BigInteger.ZERO) < 0) {
            this.addFieldError("svn.startRev", "start revision (startRev) must be positive.");
            return;
        }
        if (this.svn.isSetInitialImport() && BaseEditRepositoryAction.nullOrEmpty(this.svn.getInitialImport())) {
            this.svn.unsetInitialImport();
        }
        if (this.svn.isSetCps() && this.svn.getCps() == 0.0f) {
            this.svn.unsetCps();
        } else if (this.svn.isSetCps() && this.svn.getCps() < 0.0f) {
            this.addFieldError("svn.cps", "CPS must be positive.");
            return;
        }
        String cs = this.svn.getCharset();
        if (this.svn.isSetCharset() && BaseEditRepositoryAction.nullOrEmpty(cs)) {
            this.svn.unsetCharset();
        }
    }

    protected static boolean nullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public String getTestSymbolic() {
        return this.testSymbolic;
    }

    public void setTestSymbolic(String testSymbolic) {
        this.testSymbolic = testSymbolic;
    }

    public String getTestPath() {
        return this.testPath;
    }

    public void setTestPath(String testPath) {
        this.testPath = testPath;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public String getLogicalPath() {
        return this.logicalPath;
    }

    public void setLogicalPath(String logicalPath) {
        this.logicalPath = logicalPath;
    }

    public String getLogicalTail() {
        return this.logicalTail;
    }

    public void setLogicalTail(String logicalTail) {
        this.logicalTail = logicalTail;
    }

    protected void testSymbolic(RepositoryType repo) {
        try {
            if (repo.isSetSvn()) {
                SvnLogicalPathMatcher matcher = new SvnLogicalPathMatcher(repo.getSvn().getSymbolic());
                Path path = new Path(this.testPath);
                this.containerId = matcher.getContainerId(path);
                Path logical = matcher.getLogicalPath(path);
                if (logical == null) {
                    this.logicalPath = "No Logical Path";
                    this.logicalTail = "";
                } else {
                    this.logicalPath = matcher.getLogicalPath(path).getPath();
                    this.logicalTail = matcher.getLogicalTail(path).getPath();
                }
            }
        }
        catch (ConfigException e2) {
            this.addActionError(e2.getMessage());
        }
    }
}

