/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.RepositoryProperties;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.admin.actions.BaseAdminAction;
import java.io.IOException;

public class BaseRepositoryAction
extends BaseAdminAction {
    private static final int DEFAULT = -1;
    private int rep = -1;
    private int idx;
    public static final String VERIFY = "verify";

    public boolean isDefault() {
        return this.rep == -1;
    }

    public int getRep() {
        return this.rep;
    }

    public void setRep(int rep) {
        this.rep = rep;
    }

    public ConfigDocument.Config getCfg() {
        return AppConfig.getsConfig().getConfig();
    }

    public RootConfig getRootCfg() {
        return AppConfig.getsConfig();
    }

    public RepositoryHandle getRepositoryHandle() {
        RepositoryType repCfg;
        if (this.isDefault()) {
            return null;
        }
        ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
        try {
            repCfg = cfg.getRepositoryArray(this.getRep());
        }
        catch (IndexOutOfBoundsException e2) {
            return null;
        }
        String rname = repCfg.getName();
        RepositoryHandle rh = AppConfig.getsConfig().getRepositoryManager().getRepository(rname);
        return rh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryStatus getIndexerStatus() {
        try {
            Disposer.pushThreadInstance();
            RepositoryHandle handle = this.getRepositoryHandle();
            if (handle != null) {
                RepositoryStatus repositoryStatus = handle.acquireEngine().getStatus();
                return repositoryStatus;
            }
        }
        catch (RepositoryHandle.StateException stateException) {
        }
        finally {
            Disposer.popThreadInstance();
        }
        return null;
    }

    public void saveCfg() throws IOException {
        AppConfig.getsConfig().saveConfig();
    }

    public int getIdx() {
        return this.idx;
    }

    public void setIdx(int idx) {
        this.idx = idx;
    }

    public RepositoryProperties getRepoProps() {
        return this.isDefault() ? new RepositoryProperties(this.getCfg().getRepositoryDefaults()) : this.getRepositoryHandle().getCfg().getRepositoryProperties();
    }
}

