/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.ContentType;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.admin.actions.BaseAdminAction;

public class CustomizeFrontPageAction
extends BaseAdminAction {
    private String welcomeMsg;
    private String supportMsg;
    private ContentType content;
    private boolean isWelcomeMsgClicked = false;
    private boolean isSupportMsgClicked = false;

    public CustomizeFrontPageAction() {
        ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
        this.content = cfg.isSetContent() ? cfg.getContent() : ContentType.Factory.newInstance();
    }

    public String execute() throws Exception {
        if (this.welcomeMessageChanged()) {
            this.content.setFrontPageMessage(this.getWelcomeMsg());
            this.saveContent(this.content);
            this.addActionMessage("Welcome message successfully " + (StringUtil.nullOrEmpty(this.getWelcomeMsg()) ? "reset" : "changed") + ".");
        }
        if (this.supportMessageChanged()) {
            this.content.setSupportMessage(this.getSupportMsg());
            this.saveContent(this.content);
            this.addActionMessage("Support message successfully " + (StringUtil.nullOrEmpty(this.getSupportMsg()) ? "reset" : "changed") + ".");
        }
        return "success";
    }

    private boolean supportMessageChanged() {
        return this.isSupportMsgClicked && !this.getSupportMsg().equals(this.getContent().getSupportMessage());
    }

    private boolean welcomeMessageChanged() {
        return this.isWelcomeMsgClicked && !this.getWelcomeMsg().equals(this.getContent().getFrontPageMessage());
    }

    private void saveContent(ContentType c2) throws Exception {
        AppConfig.getsConfig().getConfig().setContent(c2);
        AppConfig.getsConfig().saveConfig();
    }

    public String getWelcomeMsg() {
        return this.welcomeMsg;
    }

    public void setWelcomeMsg(String welcomeMsg) {
        this.welcomeMsg = welcomeMsg;
    }

    public String getSupportMsg() {
        return this.supportMsg;
    }

    public void setSupportMsg(String supportMsg) {
        this.supportMsg = supportMsg;
    }

    public ContentType getContent() {
        return this.content;
    }

    public void setContent(ContentType content) {
        this.content = content;
    }

    public void setSaveWelcomeMsg(String notUsed) {
        this.isWelcomeMsgClicked = true;
    }

    public void setSaveSupportMsg(String notUsed) {
        this.isSupportMsgClicked = true;
    }

    public void setSaveBoth(String notUsed) {
        this.isSupportMsgClicked = true;
        this.isWelcomeMsgClicked = true;
    }
}

