/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.P4RepType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.SvnRepType;
import com.cenqua.fisheye.config1.UserPassAuthType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.svn.SvnLogicalPathMatcher;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.admin.actions.BaseEditRepositoryAction;

public class EditRepositoryAction
extends BaseEditRepositoryAction {
    private boolean askreidx = false;
    private boolean askrestart = false;
    private String verify = null;

    public boolean isAskreidx() {
        return this.askreidx;
    }

    public boolean isAskrestart() {
        return this.askrestart;
    }

    public void setVerify(String verify) {
        this.verify = verify;
    }

    public String execute() throws Exception {
        ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
        try {
            RepositoryType editing = cfg.getRepositoryArray(this.rep);
            if (this.testSymbolic != null) {
                editing = (RepositoryType)cfg.getRepositoryArray(this.rep).copy();
            }
            editing.setDescription(this.repository.getDescription());
            if (!editing.isSetStoreDiff()) {
                editing.setStoreDiff(true);
            }
            this.askreidx = false;
            this.askreidx = !editing.isSetStoreDiff() ? this.askreidx || this.repository.getStoreDiff() : this.askreidx || editing.getStoreDiff() != this.repository.getStoreDiff();
            editing.setStoreDiff(this.repository.getStoreDiff());
            if (editing.isSetCvs()) {
                this.updateCVS(editing);
            } else if (editing.isSetSvn()) {
                this.updateSVN(editing);
            } else if (editing.isSetPerforce()) {
                this.updateP4(editing);
            }
            if (this.testSymbolic != null) {
                this.testSymbolic(editing);
                return "input";
            }
            AppConfig.getsConfig().saveConfig();
        }
        catch (IndexOutOfBoundsException e2) {
            Logs.APP_LOG.info((Object)"admin error: ", (Throwable)e2);
            this.addActionError("Bad repository index " + this.rep);
            return "error";
        }
        return this.verify != null ? "verify" : "success";
    }

    private void updateP4(RepositoryType editing) {
        P4RepType p4Editing = editing.getPerforce();
        this.checkForAndSetP4Restart(p4Editing);
        p4Editing.setServer(this.p4.getServer());
        p4Editing.setPath(this.p4.getPath());
        if (this.p4.isSetPort()) {
            p4Editing.setPort(this.p4.getPort());
        } else if (p4Editing.isSetPort()) {
            p4Editing.unsetPort();
        }
        if (this.p4.isSetBlocksize()) {
            p4Editing.setBlocksize(this.p4.getBlocksize());
        } else if (p4Editing.isSetBlocksize()) {
            p4Editing.unsetBlocksize();
        }
        if (this.p4.isSetFileloglimit()) {
            p4Editing.setFileloglimit(this.p4.getFileloglimit());
        } else if (p4Editing.isSetFileloglimit()) {
            p4Editing.unsetFileloglimit();
        }
        if (this.p4.isSetCharset()) {
            p4Editing.setCharset(this.p4.getCharset());
        } else if (p4Editing.isSetCharset()) {
            p4Editing.unsetCharset();
        }
        if (this.p4.isSetAuth()) {
            p4Editing.setAuth(this.p4.getAuth());
        } else if (p4Editing.isSetAuth()) {
            p4Editing.unsetAuth();
        }
        if (this.p4.isSetCps()) {
            p4Editing.setCps(this.p4.getCps());
        } else if (p4Editing.isSetCps()) {
            p4Editing.unsetCps();
        }
        if (this.p4.isSetCommandTimeout()) {
            p4Editing.setCommandTimeout(this.p4.getCommandTimeout());
        } else if (p4Editing.isSetCommandTimeout()) {
            p4Editing.unsetCommandTimeout();
        }
        p4Editing.setUnicode(this.p4.getUnicode());
        p4Editing.setCasesensitive(this.p4.getCasesensitive());
    }

    private void updateSVN(RepositoryType editing) {
        this.checkForAndSetSVNRestart(editing.getSvn());
        editing.getSvn().setUrl(this.svn.getUrl());
        editing.getSvn().setPath(this.svn.getPath());
        if (this.svn.isSetBlocksize()) {
            editing.getSvn().setBlocksize(this.svn.getBlocksize());
        } else if (editing.getSvn().isSetBlocksize()) {
            editing.getSvn().unsetBlocksize();
        }
        if (this.svn.isSetCharset()) {
            editing.getSvn().setCharset(this.svn.getCharset());
        } else if (editing.getSvn().isSetCharset()) {
            editing.getSvn().unsetCharset();
        }
        if (EditRepositoryAction.nullOrEmpty(this.svn.getAccess()) && editing.getSvn().isSetAccess()) {
            editing.getSvn().unsetAccess();
        } else if (!EditRepositoryAction.nullOrEmpty(this.svn.getAccess()) && this.svn.isSetAccess()) {
            editing.getSvn().setAccess(this.svn.getAccess());
        }
        if (this.svn.getStartRev() == null && editing.getSvn().isSetStartRev()) {
            editing.getSvn().unsetStartRev();
        } else if (this.svn.getStartRev() != null && this.svn.isSetStartRev()) {
            editing.getSvn().setStartRev(this.svn.getStartRev());
        }
        if (this.svn.isSetInitialImport()) {
            editing.getSvn().setInitialImport(this.svn.getInitialImport());
        } else if (editing.getSvn().isSetInitialImport()) {
            editing.getSvn().unsetInitialImport();
        }
        if (this.svn.isSetAuth()) {
            editing.getSvn().setAuth(this.svn.getAuth());
        } else if (editing.getSvn().isSetAuth()) {
            editing.getSvn().unsetAuth();
        }
        if (this.svn.isSetCps()) {
            editing.getSvn().setCps(this.svn.getCps());
        } else if (editing.getSvn().isSetCps()) {
            editing.getSvn().unsetCps();
        }
        if (this.svn.isSetCommandTimeout()) {
            editing.getSvn().setCommandTimeout(this.svn.getCommandTimeout());
        } else if (editing.getSvn().isSetCommandTimeout()) {
            editing.getSvn().unsetCommandTimeout();
        }
        editing.getSvn().setSymbolic(this.svnSymbolic.toXmlBean());
    }

    private void updateCVS(RepositoryType editing) {
        editing.getCvs().setDir(this.cvs.getDir());
        if (this.cvs.isSetCharset()) {
            editing.getCvs().setCharset(this.cvs.getCharset());
        } else if (editing.getCvs().isSetCharset()) {
            editing.getCvs().unsetCharset();
        }
        if (!StringUtil.equal(editing.getCvs().getDir(), this.cvs.getDir())) {
            this.askrestart = true;
        }
    }

    private void checkForAndSetSVNRestart(SvnRepType current) {
        if (current.getCommandTimeout() == null) {
            current.setCommandTimeout("");
        }
        if (!(current.getCps() == this.svn.getCps() && StringUtil.equal(current.getPath(), this.svn.getPath()) && StringUtil.equal(current.getUrl(), this.svn.getUrl()) && this.numbersEqual(current.getBlocksize(), this.svn.getBlocksize()) && StringUtil.equal(current.getCharset(), this.svn.getCharset()) && StringUtil.equal(current.getAccess(), this.svn.getAccess()) && StringUtil.equal(current.getCommandTimeout(), this.svn.getCommandTimeout()) && this.numbersEqual(current.getStartRev(), this.svn.getStartRev()) && this.authsEqual(current.getAuth(), this.svn.getAuth()))) {
            this.askrestart = true;
        }
        try {
            SvnLogicalPathMatcher currentMatcher = new SvnLogicalPathMatcher(current.getSymbolic());
            SvnLogicalPathMatcher newMatcher = new SvnLogicalPathMatcher(this.svnSymbolic.toXmlBean());
            this.askreidx = !currentMatcher.equals(newMatcher);
        }
        catch (ConfigException e2) {
            this.askreidx = true;
        }
        this.askreidx = this.svn.getInitialImport() == null || this.svn.getInitialImport().equals("none") ? this.askreidx || current.getInitialImport() != null && !current.getInitialImport().equals("none") : this.askreidx || !StringUtil.equal(current.getInitialImport(), this.svn.getInitialImport());
    }

    private void checkForAndSetP4Restart(P4RepType current) {
        if (!(current.getCps() == this.p4.getCps() && this.numbersEqual(current.getPort(), this.p4.getPort()) && current.getUnicode() == this.p4.getUnicode() && StringUtil.equal(current.getPath(), this.p4.getPath()) && StringUtil.equal(current.getServer(), this.p4.getServer()) && this.numbersEqual(current.getBlocksize(), this.p4.getBlocksize()) && this.numbersEqual(current.getFileloglimit(), this.p4.getFileloglimit()) && StringUtil.equal(current.getCharset(), this.p4.getCharset()) && StringUtil.equal(current.getCommandTimeout(), this.p4.getCommandTimeout()) && this.authsEqual(current.getAuth(), this.p4.getAuth()))) {
            this.askrestart = true;
        }
        if (current.getCasesensitive() != this.p4.getCasesensitive()) {
            this.askreidx = true;
        }
    }

    private boolean authsEqual(UserPassAuthType a1, UserPassAuthType a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        return StringUtil.equal(a1.getUsername(), a2.getUsername()) && StringUtil.equal(a1.getPassword(), a2.getPassword());
    }

    private boolean numbersEqual(Number num1, Number num2) {
        if (num1 == num2) {
            return true;
        }
        if (num1 == null || num2 == null) {
            return false;
        }
        return num1.equals(num2);
    }

    public String doDefault() throws Exception {
        ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
        try {
            this.repository = cfg.getRepositoryArray(this.rep);
            this.cvs = this.repository.getCvs();
            this.svn = this.repository.getSvn();
            this.p4 = this.repository.getPerforce();
            if (this.svn != null) {
                this.svnSymbolic.setup(this.svn);
            }
            if (this.cvs != null) {
                this.repository.setStoreDiff(true);
            }
        }
        catch (IndexOutOfBoundsException e2) {
            Logs.APP_LOG.info((Object)"admin error: ", (Throwable)e2);
            this.addActionError("Bad repository index " + this.rep);
            return "error";
        }
        return "success";
    }

    public void validate() {
        this.svnSymbolic.setup();
        super.validate();
        if (this.hasErrors()) {
            return;
        }
        if (this.isReallyCvs()) {
            this.validateForCVS();
        } else if (this.getRealRepository().isSetSvn()) {
            this.validateForSVN();
        } else if (this.getRealRepository().isSetPerforce()) {
            this.validateForP4();
        }
    }

    private boolean isReallyCvs() {
        RepositoryType rep = this.getRealRepository();
        return rep == null || rep.isSetCvs();
    }

    public RepositoryType getRealRepository() {
        ConfigDocument.Config cfg = AppConfig.getsConfig().getConfig();
        try {
            return cfg.getRepositoryArray(this.rep);
        }
        catch (IndexOutOfBoundsException e2) {
            Logs.APP_LOG.info((Object)"admin error: ", (Throwable)e2);
            this.addActionError("Bad repository index " + this.rep);
            return null;
        }
    }
}

