/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.config1.LinkerSimpleType;
import com.cenqua.fisheye.config1.LinkerType;
import com.cenqua.fisheye.web.admin.actions.AbstractEditLinkerAction;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class EditSimpleLinkerAction
extends AbstractEditLinkerAction {
    private LinkerSimpleType simple = LinkerSimpleType.Factory.newInstance();

    public LinkerSimpleType getSimple() {
        return this.simple;
    }

    protected void loadLinker(LinkerType linker) {
        LinkerSimpleType editing = linker.getSimpleArray(this.getIdx());
        this.simple.setHref(editing.getHref());
        this.simple.setRegex(editing.getRegex());
        if (editing.isSetDescription()) {
            this.simple.setDescription(editing.getDescription());
        }
    }

    protected void saveLinker(LinkerType linker) {
        linker.setSimpleArray(this.getIdx(), this.simple);
    }

    public void validate() {
        try {
            Pattern.compile(this.simple.getRegex());
        }
        catch (PatternSyntaxException e2) {
            this.addFieldError("simple.regex", "Invalid Regular Expression: " + e2.getMessage());
        }
    }
}

