/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions;

import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.config1.WatchType;
import com.cenqua.fisheye.web.admin.actions.BaseRepositoryAction;

public class RepWatchesEditAction
extends BaseRepositoryAction {
    private int watchesEnabled;
    public String cancel;
    private String repname;

    public String getRepname() {
        return this.repname;
    }

    public void setCancel(String cancel) {
        this.cancel = cancel;
    }

    public int getWatchesEnabled() {
        return this.watchesEnabled;
    }

    public void setWatchesEnabled(int watchesEnabled) {
        this.watchesEnabled = watchesEnabled;
    }

    public String doDefault() throws Exception {
        WatchType watchCfg;
        ConfigDocument.Config cfg = this.getCfg();
        if (this.isDefault()) {
            watchCfg = cfg.getRepositoryDefaults().getWatches();
        } else {
            try {
                RepositoryType rep = cfg.getRepositoryArray(this.getRep());
                watchCfg = rep.getWatches();
                this.repname = rep.getName();
            }
            catch (IndexOutOfBoundsException e2) {
                this.addActionError("Bad repository index " + this.getRep());
                return "error";
            }
        }
        this.watchesEnabled = watchCfg != null ? (watchCfg.getEnabled() ? 1 : 0) : 2;
        return "success";
    }

    public String execute() throws Exception {
        if (this.cancel != null) {
            return "success";
        }
        ConfigDocument.Config cfg = this.getCfg();
        if (this.isDefault()) {
            cfg.getRepositoryDefaults().getWatches().setEnabled(this.watchesEnabled == 1);
        } else {
            try {
                RepositoryType rep = cfg.getRepositoryArray(this.getRep());
                if (this.watchesEnabled == 2) {
                    if (rep.isSetWatches()) {
                        rep.unsetWatches();
                    }
                } else {
                    if (!rep.isSetWatches()) {
                        rep.addNewWatches();
                    }
                    rep.getWatches().setEnabled(this.watchesEnabled == 1);
                }
                this.repname = rep.getName();
            }
            catch (IndexOutOfBoundsException e2) {
                this.addActionError("Bad repository index " + this.getRep());
                return "error";
            }
        }
        this.saveCfg();
        return "success";
    }
}

