/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.admin.actions.sec;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.CustomSecurityConfigType;
import com.cenqua.fisheye.config1.SecurityType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.CustomAuth;
import com.opensymphony.xwork.ActionSupport;
import java.io.Writer;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;

public class CustomAuthEditAction
extends ActionSupport {
    private CustomSecurityConfigType customSec;

    public CustomAuthEditAction() {
        SecurityType sec = this.getCfg().getSecurity();
        if (sec.isSetCustom()) {
            this.customSec = sec.getCustom();
        } else {
            this.customSec = CustomSecurityConfigType.Factory.newInstance();
            this.customSec.setAutoAdd(true);
            this.customSec.setPositiveCacheTtl("5 mins");
        }
    }

    public CustomSecurityConfigType getCustomAuth() {
        return this.customSec;
    }

    public ConfigDocument.Config getCfg() {
        return AppConfig.getsConfig().getConfig();
    }

    public String doDefault() throws Exception {
        return "success";
    }

    public String execute() throws Exception {
        if (this.hasErrors()) {
            return "error";
        }
        this.getCfg().getSecurity().setCustom(this.customSec);
        AppConfig.getsConfig().saveConfig();
        AppConfig.getsConfig().getUserManager().reload(this.getCfg());
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        String ndc = "custom-auth-" + System.currentTimeMillis();
        Writer writer = new Writer(){

            public void write(char[] chars, int i2, int i1) {
                CustomAuthEditAction.this.addActionError(new String(chars, i2, i1));
            }

            public void flush() {
            }

            public void close() {
            }
        };
        Logger logger = Logs.makeAnonymousLogger();
        Appender appender = Logs.makeTestAppender(writer, ndc, null);
        logger.addAppender(appender);
        try {
            NDC.push((String)ndc);
            new CustomAuth(this.customSec, logger, Logs.PERF_LOG);
        }
        catch (Throwable e2) {
            logger.error((Object)("Could not instantiate Authenticator: " + this.customSec.getClassname()), e2);
        }
        finally {
            NDC.pop();
            logger.removeAppender(appender);
        }
    }
}

