/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.filters;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FisheyeVersionInfo;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.config.AdminConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.web.LoginServlet;
import com.cenqua.fisheye.web.PreferenceManager;
import com.cenqua.fisheye.web.ServletUtils;
import com.cenqua.fisheye.web.filters.AdminApiActionRewrite;
import com.cenqua.fisheye.web.filters.CrucbileActionRewrite;
import com.cenqua.fisheye.web.filters.JsonRewrite;
import com.cenqua.fisheye.web.filters.ProjectPermaidRewrite;
import com.cenqua.fisheye.web.filters.ReviewPermaidRewrite;
import com.cenqua.fisheye.web.filters.RewriteRule;
import com.cenqua.fisheye.web.security.UserDetector;
import com.cenqua.fisheye.web.util.WrappedRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TotalityFilter
implements Filter {
    private final List<RewriteRule> rules = new ArrayList<RewriteRule>();
    private static final ThreadLocal<Context> context = new ThreadLocal();

    public void init(FilterConfig filterConfig) throws ServletException {
        this.rules.add(new JsonRewrite());
        this.rules.add(new AdminApiActionRewrite());
        if (FisheyeVersionInfo.CRUCIBLE_MODE) {
            this.rules.add(new ReviewPermaidRewrite());
            this.rules.add(new ProjectPermaidRewrite());
            this.rules.add(new CrucbileActionRewrite());
        }
    }

    public static HttpServletRequest getRequest() {
        return TotalityFilter.getContext().getRequest();
    }

    public static HttpServletResponse getResponse() {
        return TotalityFilter.getContext().getResponse();
    }

    private static Context getContext() {
        Context c2 = context.get();
        if (c2 == null) {
            throw new RuntimeException("Called getContext outside request");
        }
        return c2;
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        String url = ServletUtils.getPostContextPath(req);
        WrappedRequest wr = new WrappedRequest(req);
        boolean redirectRequired = false;
        for (RewriteRule rule : this.rules) {
            String rewrite;
            Matcher matcher = rule.applyRule(url);
            if (matcher == null || (rewrite = rule.rewrite(matcher, wr)) == null) continue;
            url = rewrite;
            redirectRequired = true;
        }
        if (redirectRequired) {
            wr.getRequestDispatcher(url).forward((ServletRequest)wr, (ServletResponse)resp);
            return;
        }
        if (this.requiresSetup() && !TotalityFilter.isSetupUrl(url) && !TotalityFilter.isStaticContent(url)) {
            resp.sendRedirect(wr.getContextPath() + "/setup");
            return;
        }
        boolean goToLoginDueToError = false;
        UserLogin user = null;
        try {
            UserDetector ud = new UserDetector();
            user = ud.process((HttpServletRequest)wr, resp);
        }
        catch (LicensePolicyException e2) {
            Logs.APP_LOG.warn((Object)("problem authenticating user: " + e2.getMessage()));
            wr.setAttribute("errormsg", e2.getMessage());
            goToLoginDueToError = true;
        }
        if ((goToLoginDueToError || this.requiresLogin(user)) && !this.isOutsideLogin(url)) {
            LoginServlet.redirectToLogin((HttpServletRequest)wr, resp);
            return;
        }
        PreferenceManager.doFilter((HttpServletRequest)wr, resp);
        this.setCachingHeaders(user, resp);
        Context oldctx = context.get();
        try {
            context.set(new Context((HttpServletRequest)wr, resp));
            filterChain.doFilter((ServletRequest)wr, (ServletResponse)resp);
        }
        finally {
            context.set(oldctx);
        }
    }

    private boolean requiresLogin(UserLogin user) {
        if (user != null) {
            return false;
        }
        RootConfig root = AppConfig.getsConfig();
        return !root.getConfig().getSecurity().getAllowAnon();
    }

    private void setCachingHeaders(UserLogin user, HttpServletResponse response) {
        if (user != null) {
            response.setHeader("Cache-Control", "private");
        }
    }

    private boolean requiresSetup() {
        RootConfig rootConfig = AppConfig.getsConfig();
        AdminConfig acfg = rootConfig.getAdminConfig();
        return !acfg.haveDoneInitialSetup() || rootConfig.getLicense() == null || rootConfig.getLicense().isTerminated();
    }

    private boolean isOutsideLogin(String path) {
        return TotalityFilter.isStaticContent(path) || TotalityFilter.isSetupUrl(path) || path.startsWith("/admin/") || path.equals("/admin") || path.equals("/login") || path.startsWith("/login/") || path.startsWith("/download/") || this.handlesOwnSecurity(path) || path.equals("/logout");
    }

    private boolean handlesOwnSecurity(String path) {
        return path.startsWith("/api") || path.startsWith("/rest-service/") || path.startsWith("/service/");
    }

    public static boolean isSetupUrl(String path) {
        return path.equals("/setup");
    }

    public static boolean isStaticContent(String path) {
        return path.startsWith("/WEB-INF/") || path.equals("/favicon.ico") || path.startsWith("/static/") || path.startsWith("/uar/") || path.equals("/browser.css.jsp");
    }

    private static class Context {
        private HttpServletRequest request;
        private HttpServletResponse response;

        public Context(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }
    }
}

