/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.profile.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.FEUser;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.web.UserProfile;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import com.opensymphony.webwork.interceptor.ServletResponseAware;
import com.opensymphony.xwork.ActionSupport;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractProfileAction
extends ActionSupport
implements ServletRequestAware,
ServletResponseAware {
    private boolean changePasswordEnabled = false;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected UserProfile profile = new UserProfile();

    public boolean isChangePasswordEnabled() {
        return this.changePasswordEnabled;
    }

    public boolean isMailerConfigured() {
        return AppConfig.getsConfig().getMailer() != null && AppConfig.getsConfig().getMailer().isConfigured();
    }

    protected void configChangePasswordEnabled(FEUser feu) {
        this.changePasswordEnabled = feu.getAuthType() == 1;
    }

    protected void configChangePasswordEnabled(String username) throws DbException {
        FEUser feu = AppConfig.getsConfig().getUserManager().getUser(username);
        this.configChangePasswordEnabled(feu);
    }

    protected UserLogin getUserLogin() {
        return AppConfig.getsConfig().getUserManager().getCurrentUser(this.request);
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void setServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public UserProfile getProfile() {
        return this.profile;
    }
}

