/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tarball;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.web.tarball.TarballAction;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipBaller
extends TarballAction.AbstractBaller {
    private ZipOutputStream out;
    private boolean emptyZipFile = true;

    public ZipBaller(RevisionCache CRep, Path prefix) {
        super(CRep, prefix);
    }

    public void start(OutputStream os) {
        this.out = new ZipOutputStream(new BufferedOutputStream(os));
        this.out.setComment("zip of " + this.mPrefix + ", created by FishEye");
    }

    public void done() throws IOException {
        if (this.emptyZipFile) {
            this.writeEmptyMarker();
        }
        this.out.finish();
        this.out.close();
    }

    public void writeFile(TarballAction.BallEntry entry, String vpath) throws IOException, RCSParser.ParseException, DbException {
        this.emptyZipFile = false;
        ZipEntry zentry = new ZipEntry(vpath);
        zentry.setTime(entry.date);
        this.out.putNextEntry(zentry);
        if (entry.binary) {
            this.mCRep.getBinaryRevision(entry.key, this.out);
        } else {
            this.mCRep.getTextRevision(entry.key, this.out, null, entry.symrev);
        }
        this.out.closeEntry();
    }

    private void writeEmptyMarker() throws IOException {
        ZipEntry zentry = new ZipEntry("empty_zip.txt");
        zentry.setTime(System.currentTimeMillis());
        this.out.putNextEntry(zentry);
        this.out.write("No matching files.\n".getBytes());
        this.out.closeEntry();
    }
}

