/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.util;

import com.cenqua.fisheye.util.Interval;
import java.awt.Dimension;
import javax.servlet.http.HttpServletRequest;

public class ParamUtils {
    public static int parseInt(String str, int def) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e2) {
            return def;
        }
    }

    public static Integer parseInteger(String str, Integer def) {
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e2) {
            return def;
        }
    }

    public static Interval parseSpan(String str, Interval def) {
        if (str == null) {
            return def;
        }
        try {
            return new Interval(str);
        }
        catch (NumberFormatException e2) {
            return def;
        }
    }

    public static Dimension getDimension(HttpServletRequest req, int w, int h2) {
        w = ParamUtils.parseInt(req.getParameter("w"), w);
        h2 = ParamUtils.parseInt(req.getParameter("h"), h2);
        return new Dimension(w, h2);
    }
}

