/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class PatchEngine {
    private TreeMap jobs = new TreeMap();

    public void loadJobs() throws IOException {
        TreeMap job = null;
        BufferedReader in = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream("patch.properties")));
        String line = "";
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).endsWith(":")) {
                job = (TreeMap)this.jobs.get(line = line.substring(0, line.length() - 1));
                if (job != null) continue;
                job = new TreeMap();
                this.jobs.put(line, job);
                continue;
            }
            PatchEntry entry = new PatchEntry(line);
            job.put(line, entry);
        }
        in.close();
    }

    public void patch(String filename, TreeMap entries) throws IOException {
        File file = new File(filename);
        if (!file.isFile()) {
            System.out.println(String.valueOf(filename) + " is not a file");
            return;
        }
        System.out.println("Patching " + filename);
        File tempFile = File.createTempFile("SHOCK.", ".Team");
        ZipInputStream in = new ZipInputStream(new FileInputStream(file));
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(tempFile));
        out.setMethod(8);
        out.setLevel(0);
        ZipEntry next = null;
        while ((next = in.getNextEntry()) != null) {
            Object var10_11;
            ZipEntry zipEntry = new ZipEntry(next.getName());
            zipEntry.setComment(next.getComment());
            zipEntry.setExtra(next.getExtra());
            zipEntry.setTime(next.getTime());
            try {
                try {
                    out.putNextEntry(zipEntry);
                    if (entries.containsKey(next.getName())) {
                        PatchEntry patchEntry = (PatchEntry)entries.get(next.getName());
                        this.streamcopy(patchEntry.getInputStream(), out);
                        entries.remove(next.getName());
                    } else {
                        this.streamcopy(in, out);
                    }
                    out.closeEntry();
                }
                catch (ZipException zipException) {}
            }
            catch (Throwable throwable) {
                var10_11 = null;
                in.closeEntry();
                throw throwable;
            }
            var10_11 = null;
            in.closeEntry();
        }
        this.add(entries, out);
        out.close();
        in.close();
        tempFile.setLastModified(file.lastModified());
        file.delete();
        tempFile.renameTo(file);
        System.out.println("Done");
    }

    private void streamcopy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[4096];
        while ((read = in.read(buffer)) >= 0) {
            out.write(buffer, 0, read);
        }
    }

    private void add(TreeMap entries, ZipOutputStream out) throws IOException {
        Iterator iter = entries.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            ZipEntry zipEntry = new ZipEntry(key);
            out.putNextEntry(zipEntry);
            PatchEntry patchEntry = (PatchEntry)entries.get(key);
            this.streamcopy(patchEntry.getInputStream(), out);
            out.closeEntry();
        }
    }

    public static void main(String[] argsp) throws Exception {
        PatchEngine engine = new PatchEngine();
        engine.loadJobs();
        Iterator iter = engine.jobs.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            engine.patch(key, (TreeMap)engine.jobs.get(key));
        }
    }
}

