/*
 * Decompiled with CFR 0.152.
 */
package cenqua_com_licensing.atlassian.commons.codec.language;

import cenqua_com_licensing.atlassian.commons.codec.EncoderException;
import cenqua_com_licensing.atlassian.commons.codec.StringEncoder;
import cenqua_com_licensing.atlassian.commons.codec.language.SoundexUtils;

public class RefinedSoundex
implements StringEncoder {
    public static final RefinedSoundex US_ENGLISH = new RefinedSoundex();
    public static final char[] US_ENGLISH_MAPPING = "01360240043788015936020505".toCharArray();
    private char[] soundexMapping;

    public RefinedSoundex() {
        this(US_ENGLISH_MAPPING);
    }

    public RefinedSoundex(char[] mapping) {
        this.soundexMapping = mapping;
    }

    public int difference(String s1, String s2) throws EncoderException {
        return SoundexUtils.difference(this, s1, s2);
    }

    public Object encode(Object pObject) throws EncoderException {
        if (!(pObject instanceof String)) {
            throw new EncoderException("Parameter supplied to RefinedSoundex encode is not of type java.lang.String");
        }
        return this.soundex((String)pObject);
    }

    public String encode(String pString) {
        return this.soundex(pString);
    }

    char getMappingCode(char c2) {
        if (!Character.isLetter(c2)) {
            return '\u0000';
        }
        return this.soundexMapping[Character.toUpperCase(c2) - 65];
    }

    /*
     * WARNING - void declaration
     */
    public String soundex(String str) {
        if (str == null) {
            return null;
        }
        if ((str = SoundexUtils.clean(str)).length() == 0) {
            return str;
        }
        StringBuffer sBuf = new StringBuffer();
        sBuf.append(str.charAt(0));
        char last = '*';
        int n = 0;
        while (n < str.length()) {
            void current;
            char i2 = this.getMappingCode(str.charAt(n));
            if (i2 != last) {
                if (i2 != '\u0000') {
                    sBuf.append(i2);
                }
                last = i2;
            }
            ++current;
        }
        return sBuf.toString();
    }
}

