/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.impl;

import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.crucible.spi.TxTemplate;
import com.atlassian.crucible.spi.data.ProjectData;
import com.atlassian.crucible.spi.services.ProjectService;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.managers.ProjectManager;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="projectService")
public class DefaultProjectService
implements ProjectService {
    ProjectManager projectManager;
    TxTemplate txTemplate;

    @Autowired
    public DefaultProjectService(TxTemplate txTemplate, ProjectManager projectManager) {
        this.txTemplate = txTemplate;
        this.projectManager = projectManager;
    }

    @Override
    public List<ProjectData> getAllProjects() {
        return this.txTemplate.execute(new TxCallback<List<ProjectData>>(){

            @Override
            public List<ProjectData> doInTransaction(TransactionStatus status) {
                ArrayList<ProjectData> projectData = new ArrayList<ProjectData>();
                for (Project p : DefaultProjectService.this.projectManager.getAllProjects()) {
                    projectData.add(new ProjectData(p.getId(), p.getName(), p.getKey(), p.getDefaultRepositoryName(), p.getPermissionScheme().getId(), p.isAllowReviewersToJoin()));
                }
                return projectData;
            }
        });
    }
}

