/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.impl;

import com.cenqua.crucible.actions.admin.project.UserData;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.DbException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static CrucibleUser getUserByName(String name) {
        CrucibleUserManager userManager = (CrucibleUserManager)SpringContext.getComponent("crucibleUserManager");
        CrucibleUser u = null;
        try {
            u = userManager.findUserByName(name);
        }
        catch (DbException dbException) {
            // empty catch block
        }
        if (u == null) {
            throw new RuntimeException("No such user:" + name);
        }
        return u;
    }

    public static UserData crucibleUserToUserData(CrucibleUser user) {
        return user == null ? null : new UserData(user.getUserName(), user.getDisplayName());
    }

    public static Set<UserData> crucibleUsersToUserDataSet(Collection<CrucibleUser> users) {
        HashSet<UserData> names = new HashSet<UserData>();
        for (CrucibleUser u : users) {
            names.add(Utils.crucibleUserToUserData(u));
        }
        return names;
    }

    public static Set<CrucibleUser> userDataCollectionToCrucibleUserSet(Collection<UserData> userData) {
        HashSet<CrucibleUser> users = new HashSet<CrucibleUser>();
        if (userData != null) {
            for (UserData d2 : userData) {
                users.add(Utils.getUserByName(d2.getUserName()));
            }
        }
        return users;
    }
}

