/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.rpc;

import com.atlassian.crucible.spi.rpc.RpcAuthHelper;
import com.cenqua.fisheye.config.SpringContext;
import com.sun.ws.rest.spi.resource.Singleton;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.QueryParam;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="/auth-v1")
@ConsumeMime(value={"application/xml"})
@ProduceMime(value={"application/xml"})
@Singleton
public class RestAuthService {
    private RpcAuthHelper authHelper;

    @GET
    @Path(value="login")
    public LoginResult login(@QueryParam(value="userName") String userName, @QueryParam(value="password") String password) {
        LoginResult result = new LoginResult();
        try {
            result.token = this.getAuthHelper().login(userName, password, "/rest-service/");
        }
        catch (Exception e2) {
            result.error = e2.getMessage();
        }
        return result;
    }

    private RpcAuthHelper getAuthHelper() {
        if (this.authHelper == null) {
            this.authHelper = (RpcAuthHelper)SpringContext.getComponent("rpcAuthHelper");
        }
        return this.authHelper;
    }

    @XmlRootElement
    private static class LoginResult {
        public String token;
        public String error;

        private LoginResult() {
        }
    }
}

