/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.rpc;

import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.FisheyeReviewItemData;
import com.atlassian.crucible.spi.data.GeneralCommentData;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.data.ReviewItemData;
import com.atlassian.crucible.spi.data.VersionedLineCommentData;
import com.atlassian.crucible.spi.services.ReviewService;
import com.cenqua.fisheye.config.SpringContext;
import com.sun.ws.rest.spi.resource.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.QueryParam;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/reviews-v1")
@ConsumeMime(value={"application/xml", "application/json"})
@ProduceMime(value={"application/xml", "application/json"})
@Singleton
public class RestReviewService {
    private ReviewService reviewService;

    @GET
    public Reviews getAllReviews(@QueryParam(value="state") String states) {
        List<Object> reviews = new ArrayList();
        if (!StringUtils.isEmpty((String)states)) {
            String[] stateNames;
            ArrayList<ReviewData.State> stateEnums = new ArrayList<ReviewData.State>();
            for (String s : stateNames = states.split(",")) {
                stateEnums.add(ReviewData.State.valueOf(s.trim()));
            }
            reviews = this.getReviewService().getReviewsInStates(stateEnums.toArray(new ReviewData.State[stateEnums.size()]));
        } else {
            reviews = this.getReviewService().getAllReviews();
        }
        return new Reviews(reviews);
    }

    @POST
    public ReviewData createReview(CreateReview createReview) {
        if (createReview.patch == null) {
            return this.getReviewService().createReview(createReview.reviewData);
        }
        return this.getReviewService().createReviewFromPatch(createReview.reviewData, createReview.patch);
    }

    @GET
    @Path(value="{id}")
    public ReviewData getReview(@PathParam(value="id") String id) {
        return this.getReviewService().getReview(this.stringToId(id));
    }

    @GET
    @Path(value="{id}/reviewers")
    public Reviewers getReviewers(@PathParam(value="id") String id) {
        return new Reviewers(this.getReviewService().getReviewers(this.stringToId(id)));
    }

    @GET
    @Path(value="{id}/reviewitems")
    public ReviewItems getReviewItemsForReview(@PathParam(value="id") String id) {
        return new ReviewItems(this.getReviewService().getReviewItemsForReview(this.stringToId(id)));
    }

    @DELETE
    @Path(value="{id}/reviewitems/{riId}")
    public void removeReviewItem(@PathParam(value="id") String reviewId, @PathParam(value="riId") String itemId) {
        this.getReviewService().removeReviewItem(this.stringToId(reviewId), this.stringToId(itemId));
    }

    @GET
    @Path(value="{id}/reviewitems/{riId}")
    public FisheyeReviewItemData getReviewItem(@PathParam(value="id") String reviewId, @PathParam(value="riId") String itemId) {
        return this.getReviewService().getReviewItem(this.stringToId(reviewId), this.stringToId(itemId));
    }

    @GET
    @Path(value="{id}/comments")
    public Comments getAllComments(@PathParam(value="id") String id) {
        List<GeneralCommentData> generalComments = this.getReviewService().getGeneralComments(this.stringToId(id));
        List<VersionedLineCommentData> versionedComments = this.getReviewService().getAllRevisionComments(this.stringToId(id));
        return new Comments(generalComments, versionedComments);
    }

    private <T> PermId<T> stringToId(String id) {
        return new PermId(id);
    }

    private ReviewService getReviewService() {
        if (this.reviewService == null) {
            this.reviewService = (ReviewService)SpringContext.getComponent("reviewService");
        }
        return this.reviewService;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlRootElement
    private static class Comments {
        public List<VersionedLineCommentData> versionedComment;
        public List<GeneralCommentData> generalComment;

        public Comments() {
        }

        public Comments(List<GeneralCommentData> generalComments, List<VersionedLineCommentData> versionedComments) {
            this.generalComment = generalComments;
            this.versionedComment = versionedComments;
        }
    }

    @XmlRootElement
    public static class CreateReview {
        public ReviewData reviewData;
        public String patch;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlRootElement
    private static class ReviewItems {
        public List<FisheyeReviewItemData> reviewItem;

        public ReviewItems() {
        }

        public ReviewItems(List<ReviewItemData> reviewItemsForReview) {
            this.reviewItem = new ArrayList<FisheyeReviewItemData>();
            for (ReviewItemData rid : reviewItemsForReview) {
                this.reviewItem.add((FisheyeReviewItemData)rid);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlRootElement
    public static class Reviewers {
        public Set<String> reviewer;

        public Reviewers() {
        }

        public Reviewers(Set<String> reviewer) {
            this.reviewer = reviewer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlRootElement
    public static class Reviews {
        public List<ReviewData> reviewData = null;

        public Reviews() {
        }

        public Reviews(List<ReviewData> allReviews) {
            this.reviewData = allReviews;
        }
    }
}

