/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crucible.spi.rpc;

import com.atlassian.crucible.spi.PermId;
import com.atlassian.crucible.spi.data.GeneralCommentData;
import com.atlassian.crucible.spi.data.ReviewData;
import com.atlassian.crucible.spi.data.ReviewItemData;
import com.atlassian.crucible.spi.data.VersionedLineCommentData;
import com.atlassian.crucible.spi.rpc.RpcReviewService;
import com.atlassian.crucible.spi.rpc.SecuredRpcService;
import com.atlassian.crucible.spi.services.ReviewService;
import javax.annotation.Resource;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.WebServiceContext;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(endpointInterface="com.atlassian.crucible.spi.rpc.RpcReviewService", name="Review", serviceName="Review")
@SOAPBinding(style=SOAPBinding.Style.RPC, use=SOAPBinding.Use.LITERAL)
public class RpcReviewServiceImpl
implements RpcReviewService,
SecuredRpcService {
    @Autowired
    private ReviewService reviewService;
    private WebServiceContext context;

    @Override
    public ReviewData createReview(String token, ReviewData review) {
        return this.reviewService.createReview(review);
    }

    @Override
    public ReviewData createReviewFromPatch(@WebParam(name="token") String token, @WebParam(name="review") ReviewData review, @WebParam(name="patch") String patch) {
        return this.reviewService.createReviewFromPatch(review, patch);
    }

    @Override
    public ReviewData[] getAllReviews(String token) {
        return this.reviewService.getAllReviews().toArray(new ReviewData[0]);
    }

    @Override
    public ReviewData getReview(@WebParam(name="token") String token, PermId<ReviewData> id) {
        return this.reviewService.getReview(id);
    }

    @Override
    public ReviewData[] getReviewsInStates(@WebParam(name="token") String token, ReviewData.State[] states) {
        return this.reviewService.getReviewsInStates(states).toArray(new ReviewData[0]);
    }

    @Override
    public String[] getReviewers(@WebParam(name="token") String token, PermId<ReviewData> id) {
        return this.reviewService.getReviewers(id).toArray(new String[0]);
    }

    @Override
    public ReviewItemData addFisheyeDiff(@WebParam(name="token") String token, PermId<ReviewData> id, String repositoryName, String fromPath, String fromRevision, String toPath, String toRevision) {
        return this.reviewService.addFisheyeDiff(id, repositoryName, fromPath, fromRevision, toPath, toRevision);
    }

    @Override
    public void removeReviewItem(@WebParam(name="token") String token, PermId<ReviewData> reviewId, PermId<ReviewItemData> itemId) {
        this.reviewService.removeReviewItem(reviewId, itemId);
    }

    @Override
    public ReviewItemData[] getReviewItemsForReview(@WebParam(name="token") String token, PermId<ReviewData> id) {
        return this.reviewService.getReviewItemsForReview(id).toArray(new ReviewItemData[0]);
    }

    @Override
    public VersionedLineCommentData addComment(@WebParam(name="token") String token, PermId<ReviewItemData> id, VersionedLineCommentData comment) {
        return this.reviewService.addComment(id, comment);
    }

    @Override
    public GeneralCommentData addGeneralComment(@WebParam(name="token") String token, PermId<ReviewData> id, GeneralCommentData comment) {
        return this.reviewService.addGeneralComment(id, comment);
    }

    @Override
    public GeneralCommentData[] getGeneralComments(@WebParam(name="token") String token, PermId<ReviewData> id) {
        return this.reviewService.getGeneralComments(id).toArray(new GeneralCommentData[0]);
    }

    @Override
    public VersionedLineCommentData[] getVersionedComments(@WebParam(name="token") String token, PermId<ReviewItemData> id) {
        return this.reviewService.getVersionedComments(id).toArray(new VersionedLineCommentData[0]);
    }

    @Override
    public VersionedLineCommentData[] getAllRevisionComments(@WebParam(name="token") String token, PermId<ReviewData> id) {
        return this.reviewService.getAllRevisionComments(id).toArray(new VersionedLineCommentData[0]);
    }

    @Override
    public ReviewData changeState(@WebParam(name="token") String token, PermId<ReviewData> id, ReviewService.Action action) {
        return this.reviewService.changeState(id, action);
    }

    @Override
    public ReviewData[] getChildReviews(@WebParam(name="token") String token, PermId<ReviewData> id) {
        return this.reviewService.getChildReviews(id).toArray(new ReviewData[0]);
    }

    @Override
    public ReviewData[] getUncompletedReviewsForUser(@WebParam(name="token") String token, @WebParam(name="userName") String userName) {
        return this.reviewService.getUncompletedReviewsForUser(userName).toArray(new ReviewData[0]);
    }

    @Override
    public WebServiceContext getContext() {
        return this.context;
    }

    @Resource
    public void setContext(WebServiceContext context) {
        this.context = context;
    }
}

