/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions;

import com.cenqua.crucible.actions.BaseAction;
import com.cenqua.crucible.configuration.metrics.FieldDefinition;
import com.cenqua.crucible.configuration.metrics.MetricsConfig;
import com.cenqua.crucible.configuration.metrics.MetricsManager;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.CustomFieldList;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.PermaIdKey;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import com.cenqua.crucible.model.RevisionComment;
import com.cenqua.crucible.model.managers.CommentManager;
import com.cenqua.crucible.model.managers.ParticipantManager;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.crucible.util.Filter;
import com.cenqua.crucible.util.FilterWrap;
import com.cenqua.crucible.view.CommentDO;
import com.cenqua.crucible.view.FRXDO;
import com.cenqua.crucible.view.ParticipantStats;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewBaseAction
extends BaseAction {
    private Review review;
    private PermaIdKey permaKey = new PermaIdKey();
    private MetricsConfig metricsConfig;
    private List<Patch> reviewPatches;
    private int myDraftComments = -1;
    private int otherDraftComments = -1;

    public Review getReview() {
        if (this.review == null && this.permaKey.getKey() != null) {
            this.setReview(ReviewManager.getReviewByPermaId(this.permaKey));
        }
        return this.review;
    }

    public Project getProject() {
        return this.getReview() != null ? this.getReview().getProject() : null;
    }

    public void setReviewid(Integer id) {
        this.setReview(ReviewManager.getReviewById(id));
    }

    public Integer getReviewid() {
        if (this.review != null) {
            return this.review.getId();
        }
        return null;
    }

    public PermaIdKey getPermaKey() {
        return this.permaKey;
    }

    private void setReview(Review review) {
        this.review = review;
    }

    public String getPermaId() {
        if (this.review != null) {
            return this.review.getPermaId();
        }
        return null;
    }

    public Iterator getFRXs() throws Exception {
        try {
            LinkedList<FileRevisionExtraInfo> frxs = new LinkedList<FileRevisionExtraInfo>(this.getReview().getFrxs());
            FilterWrap fl = new FilterWrap(frxs.iterator());
            fl.registerFilter(new FRXFilter());
            return fl;
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)("Unexpected error getting FRXs from Review " + this.getReview().getPermaId()), (Throwable)e2);
            throw e2;
        }
    }

    public ReviewParticipant getParticipant() {
        return ParticipantManager.getByUser(this.getReview(), this.getCurrentUser());
    }

    public MetricsConfig getMetricsConfig() {
        Integer metricsVersion;
        if (this.metricsConfig == null && (metricsVersion = this.getReview().getMetricsVersion()) != null) {
            this.metricsConfig = MetricsManager.INSTANCE.getConfig(metricsVersion);
        }
        return this.metricsConfig;
    }

    protected void addFields(CustomFieldList dest, HashMap<String, FieldDefinition> fields) {
        dest.clearFields();
        for (FieldDefinition fd : fields.values()) {
            String val = this.getParameter(fd.getName());
            if (StringUtil.nullOrEmpty(val)) continue;
            dest.addField(fd.makeCustomField(val));
        }
    }

    public Collection getCommentFields() {
        MetricsConfig mc = this.getMetricsConfig();
        return mc != null && mc.isValid() ? mc.getCommentFields().values() : new HashSet();
    }

    public Collection getReviewFields() {
        MetricsConfig mc = this.getMetricsConfig();
        return mc != null && mc.isValid() ? mc.getReviewFields().values() : new HashSet();
    }

    public List getStates() {
        return Collections.unmodifiableList(StateManager.INSTANCE.getStates());
    }

    public boolean isWritable() throws DbException {
        return this.getReview().checkWriteAccess(this.getCurrentUser());
    }

    public boolean isReviewer() throws DbException {
        return this.getReview().isReviewer(this.getCurrentUser());
    }

    public boolean isActiveReviewer() throws DbException {
        return this.getReview().checkActiveReviewer(this.getCurrentUser());
    }

    public boolean isCompletedReviewer() throws DbException {
        return this.getReview().checkCompletedReviewer(this.getCurrentUser());
    }

    public boolean isAuthor() throws DbException {
        return this.getReview().isAuthor(this.getCurrentUser());
    }

    public boolean isModerator() throws DbException {
        return this.getReview().isModerator(this.getCurrentUser());
    }

    public boolean isFileModifiable() {
        return ReviewUtil.canDoReviewAction("action:modifyReviewFiles", this.getReview());
    }

    public boolean canSummarize() {
        return this.getReview().getState().getStateType() == StateManager.States.SUMMARIZE_STATE && ReviewUtil.canDoReviewAction("action:summarizeReview", this.getReview());
    }

    public boolean isCreator() throws DbException {
        return this.getReview().isCreator(this.getCurrentUser());
    }

    public boolean isReviewsComplete() {
        return this.getReview().getCountActiveReviewers() == 0;
    }

    public boolean isClosed() {
        return this.getReview().getState().isClosedState();
    }

    public List<Comment> getViewableComments() {
        ArrayList<Comment> vc = new ArrayList<Comment>();
        for (Comment comment : this.getReview().getComments()) {
            if (comment.isDeleted() || comment.isDraft() && !comment.getUser().equals(this.getCurrentUser())) continue;
            vc.add(comment);
        }
        return vc;
    }

    private List<RevisionComment> filterViewableRevisionComments(List<RevisionComment> comments) {
        ArrayList<RevisionComment> rcs = new ArrayList<RevisionComment>();
        for (RevisionComment rc : comments) {
            if (rc.isDeleted() || rc.isDraft() && !rc.getComment().getUser().equals(this.getCurrentUser())) continue;
            rcs.add(rc);
        }
        return rcs;
    }

    public List<RevisionComment> getRevisionComments() {
        return this.filterViewableRevisionComments(CommentManager.getRevisionComments(this.getReview()));
    }

    public Collection<Comment> getRevisionCommentComments() {
        return CommentManager.getRevisionCommentComments(this.getReview());
    }

    public Iterator getDraftCommentDOs() {
        FilterWrap fl = new FilterWrap(this.getDraftComments().iterator());
        fl.registerFilter(new CommentDOFilter(this.getCurrentUser()));
        return fl;
    }

    public Collection<Comment> getDraftComments() {
        return CommentManager.getUserReviewDraftComments(this.getReview(), this.getCurrentUser());
    }

    public int getMyDraftCommentCount() {
        if (this.myDraftComments == -1) {
            this.myDraftComments = CommentManager.countDraftComments(this.getReview(), this.getCurrentUser());
        }
        return this.myDraftComments;
    }

    public int getOtherDraftCommentCount() {
        if (this.otherDraftComments == -1) {
            this.otherDraftComments = CommentManager.countDraftComments(this.getReview(), null) - this.getMyDraftCommentCount();
        }
        return this.otherDraftComments;
    }

    public HashMap getParticipantStats() {
        return new ParticipantStats(this.getReview()).getParticipantStats();
    }

    public boolean isSideBySide() {
        return this.getUserPreferences().isSideBySide();
    }

    public boolean isSoftWrap() {
        return this.getUserPreferences().isSoftWrap();
    }

    public FRXDO makeFRXDO(FileRevisionExtraInfo frx) throws Exception {
        String keywordOpts = null;
        Source source = frx.getFileRevision().getSource();
        return source.getFRXDO(frx, this.getCurrentUser(), keywordOpts, this.isSideBySide(), this.isSoftWrap());
    }

    public List<Patch> getPatches() {
        if (this.reviewPatches == null) {
            this.reviewPatches = PatchManager.findReviewPatches(this.getReview());
        }
        return this.reviewPatches;
    }

    public List getAllowedActiveReviewers() throws DbException {
        LinkedList<CrucibleUser> allowed = new LinkedList<CrucibleUser>(this.getReview().getProject().getAllowedReviewers());
        if (allowed.isEmpty()) {
            return this.getActiveUsers();
        }
        allowed.retainAll(this.getActiveUsers());
        return allowed;
    }

    public class ParticipantInfo {
        public String name;
    }

    private class FRXFilter
    implements Filter {
        private FRXFilter() {
        }

        public Object filter(Object source) {
            try {
                return ReviewBaseAction.this.makeFRXDO((FileRevisionExtraInfo)source);
            }
            catch (Exception e2) {
                Logs.APP_LOG.error((Object)"Problem creating FRXDO from frx", (Throwable)e2);
                return null;
            }
        }
    }

    private class CommentDOFilter
    implements Filter {
        private CrucibleUser currentUser;

        public CommentDOFilter(CrucibleUser currentUser) {
            this.currentUser = currentUser;
        }

        public Object filter(Object source) {
            return new CommentDO((Comment)source, this.currentUser);
        }
    }
}

