/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.admin.permschemes;

import com.atlassian.crucible.spi.TxCallback;
import com.cenqua.crucible.actions.BaseAction;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.managers.PermissionManager;
import java.util.Set;
import org.springframework.transaction.TransactionStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdatePSActionAction
extends BaseAction {
    private String psName;
    private String action;
    private boolean anonymousUsers;
    private boolean allUsers;
    private Set<String> actionUsers;
    private Set<String> groups;
    private Set<String> roles;

    public void setPsName(String psName) {
        this.psName = psName;
    }

    public String getPsName() {
        return this.psName;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setAnonymousUsers(boolean b2) {
        this.anonymousUsers = true;
    }

    public void setAllUsers(boolean b2) {
        this.allUsers = true;
    }

    public void setActionUsers(Set<String> actionUsers) {
        this.actionUsers = actionUsers;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public String execute() throws Exception {
        return this.txTemplate.execute(new TxCallback<String>(){

            @Override
            public String doInTransaction(TransactionStatus status) throws Exception {
                PermissionScheme ps = PermissionManager.findPS(UpdatePSActionAction.this.psName);
                if (ps == null) {
                    UpdatePSActionAction.this.addActionError("Could not find Permission Scheme.");
                    return "error";
                }
                ps.removeAllUsersAction(UpdatePSActionAction.this.action);
                if (UpdatePSActionAction.this.allUsers) {
                    ps.addAllUsersAction(UpdatePSActionAction.this.action);
                }
                ps.removeAnonAction(UpdatePSActionAction.this.action);
                if (UpdatePSActionAction.this.anonymousUsers) {
                    ps.addAnonAction(UpdatePSActionAction.this.action);
                }
                ps.clearUserAction(UpdatePSActionAction.this.action);
                if (UpdatePSActionAction.this.actionUsers != null) {
                    for (String userName : UpdatePSActionAction.this.actionUsers) {
                        ps.addUserAction(userName, UpdatePSActionAction.this.action);
                    }
                }
                ps.clearGroupAction(UpdatePSActionAction.this.action);
                if (UpdatePSActionAction.this.groups != null) {
                    for (String groupName : UpdatePSActionAction.this.groups) {
                        ps.addGroupAction(groupName, UpdatePSActionAction.this.action);
                    }
                }
                ps.clearReviewRoleAction(UpdatePSActionAction.this.action);
                if (UpdatePSActionAction.this.roles != null) {
                    for (String roleName : UpdatePSActionAction.this.roles) {
                        ps.addReviewRoleAction(roleName, UpdatePSActionAction.this.action);
                    }
                }
                return "success";
            }
        });
    }
}

