/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.admin.project;

import com.atlassian.crucible.spi.impl.Utils;
import com.cenqua.crucible.actions.BaseAction;
import com.cenqua.crucible.actions.admin.project.UserData;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjectFormAction
extends BaseAction {
    public Set<UserData> getAllUsers() {
        try {
            return Utils.crucibleUsersToUserDataSet(this.getActiveUsers());
        }
        catch (DbException e2) {
            throw new RuntimeException("Error getting list of active users", e2);
        }
    }

    public Set<String> getAllPermissionSchemeNames() {
        HashSet<String> names = new HashSet<String>();
        for (PermissionScheme pm : PermissionManager.getPermissionSchemes()) {
            names.add(pm.getName());
        }
        return names;
    }

    public Collection<String> getAllRepositoryNames() {
        HashSet<String> repoData = new HashSet<String>();
        for (RepositoryHandle h2 : AppConfig.getsConfig().getRepositoryManager().getHandles()) {
            repoData.add(h2.getName());
        }
        return repoData;
    }

    public Collection<String> getAllGroups() {
        try {
            return AppConfig.getsConfig().getUserManager().getGroupInfos().keySet();
        }
        catch (DbException e2) {
            throw new RuntimeException("Error getting groups", e2);
        }
    }
}

