/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.chart;

import com.cenqua.crucible.actions.chart.SparkLineCalculator;
import com.cenqua.crucible.actions.project.BaseProjectAction;
import com.cenqua.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.reports.SparkLineResultCache;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.DateHelper;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.servlet.ServletOutputStream;
import org.jfree.chart.ChartUtilities;

public abstract class BaseSparklineAction
extends BaseProjectAction {
    private Date to;
    private Date from;
    private SparkLineResultCache sparkLineResultCache;

    protected BaseSparklineAction() {
        GregorianCalendar cal = DateHelper.getStartOfTodayAsCalendar(AppConfig.getsConfig().getTimezone());
        cal.add(6, 1);
        this.to = cal.getTime();
        cal.add(2, -1);
        this.from = cal.getTime();
    }

    public String execute() throws Exception {
        try {
            CrucibleFilter.getResponse().setContentType("image/png");
            ServletOutputStream out = CrucibleFilter.getResponse().getOutputStream();
            if (out != null) {
                ChartUtilities.writeBufferedImageAsPNG((OutputStream)out, (BufferedImage)this.sparkLineResultCache.get(this.getProject(), this.from, this.to, this.getSparkLineCalculator()).getChart());
            }
            return "none";
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)e2);
            return "none";
        }
    }

    protected int getHeight() {
        return 25;
    }

    protected int getWidth() {
        return 100;
    }

    protected Date getFromDate() {
        return this.from;
    }

    protected Date getToDate() {
        return this.to;
    }

    protected abstract SparkLineCalculator getSparkLineCalculator();

    public void setSparkLineResultCache(SparkLineResultCache sparkLineResultCache) {
        this.sparkLineResultCache = sparkLineResultCache;
    }
}

