/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.chart;

import com.cenqua.crucible.actions.chart.BaseSparklineCalculator;
import com.cenqua.crucible.model.StateChangeLog;
import com.cenqua.crucible.model.managers.LogRecordProcessor;
import com.cenqua.crucible.model.managers.StateManager;
import com.cenqua.crucible.reports.SparkLineCreator;
import com.cenqua.crucible.reports.TimeSeriesSparkLineCreator;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class OpenReviewsSparklineCalculator
extends BaseSparklineCalculator {
    private LogRecordProcessor processor = new LogRecordProcessor(){
        int days;
        final Set<String> stateSet;
        final int[] entries;
        int currentReviewId;
        String currentReviewState;
        boolean calculationsComplete;
        {
            this.days = (int)((OpenReviewsSparklineCalculator.this.getToDate().getTime() - OpenReviewsSparklineCalculator.this.getFromDate().getTime()) / 86400000L);
            this.stateSet = new HashSet<String>(Arrays.asList(StateManager.INSTANCE.getOpenStateNames()));
            this.entries = new int[this.days];
            this.currentReviewId = -1;
            this.currentReviewState = null;
            this.calculationsComplete = false;
        }

        @Override
        public void handle(StateChangeLog log) {
            int day = OpenReviewsSparklineCalculator.this.dayIndex(OpenReviewsSparklineCalculator.this.getFromDate(), log.getTimeStamp());
            if (log.getReviewId() != this.currentReviewId) {
                this.currentReviewId = log.getReviewId();
                this.currentReviewState = null;
            }
            int delta = this.calcDelta(log, this.currentReviewState, this.stateSet);
            this.currentReviewState = log.getNewState();
            int n = day < 0 ? 0 : day;
            this.entries[n] = this.entries[n] + delta;
        }

        @Override
        public void afterFinalRecord() {
            this.calculationsComplete = true;
        }

        @Override
        public double[] getData() {
            double[] data = new double[this.days];
            int currentCount = 0;
            for (int i2 = 0; i2 < this.days; ++i2) {
                data[i2] = currentCount += this.entries[i2];
            }
            return data;
        }

        @Override
        public double getSummary() {
            double[] data = this.getData();
            return data[data.length - 1];
        }

        @Override
        public boolean calculationsComplete() {
            return this.calculationsComplete;
        }

        private int calcDelta(StateChangeLog log, String currentState, Set<String> stateSet) {
            if (currentState != null && stateSet.contains(currentState)) {
                return stateSet.contains(log.getNewState()) ? 0 : -1;
            }
            return stateSet.contains(log.getNewState()) ? 1 : 0;
        }
    };

    public OpenReviewsSparklineCalculator(Date from, Date to) {
        super(from, to);
    }

    protected SparkLineCreator getCreator() {
        return new TimeSeriesSparkLineCreator();
    }

    public LogRecordProcessor getLogRecordProcessor() {
        return this.processor;
    }
}

