/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.chart;

import com.cenqua.crucible.actions.chart.BaseSparklineCalculator;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.StateChangeLog;
import com.cenqua.crucible.model.managers.LogRecordProcessor;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.reports.DistributionSparkLineCreator;
import com.cenqua.crucible.reports.SparkLineCreator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class PerReviewSparklineCalculator
extends BaseSparklineCalculator {
    private LogRecordProcessor processor = new LogRecordProcessor(){
        private static final int NUMBER_OF_BUCKETS = 30;
        private Map<Integer, Integer> attributeDistribution = new HashMap<Integer, Integer>();
        int currentReviewId = -1;
        boolean includeCurrentReview = false;
        boolean calculationsComplete = false;
        double reviewCount = 0.0;
        double attributeTotal = 0.0;

        public void handle(StateChangeLog log) {
            if (log.getReviewId() != this.currentReviewId) {
                this.processReview();
                this.currentReviewId = log.getReviewId();
            }
            if (!this.includeCurrentReview) {
                this.includeCurrentReview = PerReviewSparklineCalculator.this.includeReview(log);
            }
        }

        public void afterFinalRecord() {
            this.processReview();
            this.calculationsComplete = true;
        }

        public double[] getData() {
            int maxCount = 0;
            for (int i2 : this.attributeDistribution.keySet()) {
                if (i2 <= maxCount) continue;
                maxCount = i2;
            }
            int bucketFactor = maxCount / 30;
            if (bucketFactor == 0) {
                bucketFactor = 1;
            }
            double[] frequencies = new double[31];
            for (Map.Entry<Integer, Integer> e2 : this.attributeDistribution.entrySet()) {
                int index = e2.getKey() / bucketFactor;
                if (index > 29) {
                    index = 29;
                }
                int n = index;
                frequencies[n] = frequencies[n] + (double)e2.getValue().intValue();
            }
            return frequencies;
        }

        public double getSummary() {
            return this.reviewCount == 0.0 ? 0.0 : this.attributeTotal / this.reviewCount;
        }

        public boolean calculationsComplete() {
            return this.calculationsComplete;
        }

        private void processReview() {
            if (this.currentReviewId != -1 && this.includeCurrentReview) {
                int attributeValue = PerReviewSparklineCalculator.this.getReviewAttribute(ReviewManager.getReviewById(this.currentReviewId));
                Integer count = this.attributeDistribution.get(attributeValue);
                count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                this.reviewCount += 1.0;
                this.attributeTotal += (double)attributeValue;
                this.attributeDistribution.put(attributeValue, count);
                this.includeCurrentReview = false;
            }
        }
    };

    protected abstract boolean includeReview(StateChangeLog var1);

    protected abstract int getReviewAttribute(Review var1);

    public PerReviewSparklineCalculator(Date from, Date to) {
        super(from, to);
    }

    protected SparkLineCreator getCreator() {
        return new DistributionSparkLineCreator();
    }

    public LogRecordProcessor getLogRecordProcessor() {
        return this.processor;
    }
}

