/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.create;

import com.cenqua.crucible.actions.create.EditRevisionsAction;
import com.cenqua.crucible.model.Patch;
import com.cenqua.crucible.model.managers.PatchManager;
import com.cenqua.crucible.upload.UploadItem;
import com.cenqua.crucible.upload.UploadManager;
import com.cenqua.crucible.util.Filter;
import com.cenqua.crucible.util.FilterWrap;
import com.cenqua.crucible.util.PatchReviewCreationHelper;
import com.cenqua.crucible.view.PatchDO;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.StringUtil;
import java.io.File;
import java.util.Iterator;
import java.util.List;

public class AddPatchAction
extends EditRevisionsAction {
    private File patch;
    private String patchText;
    private String patchFileName;
    private String patchContentType;
    private String errorMessage;
    private String description;

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public File getPatch() {
        return this.patch;
    }

    public void setPatch(File patch) {
        this.patch = patch;
    }

    public String getPatchText() {
        return this.patchText;
    }

    public void setPatchText(String patchText) {
        this.patchText = patchText;
    }

    public void setPatchFileName(String patchFileName) {
        this.patchFileName = patchFileName;
    }

    public void setPatchContentType(String patchContentType) {
        this.patchContentType = patchContentType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getErrorDescription() {
        return "error.unauthorized.change.description";
    }

    public String getError() {
        return "error.unauthorized.action";
    }

    public String doView() {
        if (!this.isFileModifiable()) {
            return "AccessError";
        }
        try {
            UploadItem ui;
            if (this.patch != null) {
                ui = UploadManager.createUploadItem(this.getCurrentUser(), this.patch, this.patchFileName, this.patchContentType, this.description);
            } else if (!StringUtil.nullOrEmpty(this.patchText)) {
                ui = UploadManager.createUploadItemFromContent(this.getCurrentUser(), "pasted.txt", this.patchText.trim(), "text/plain", "pasted by user");
            } else {
                return "input";
            }
            Patch p = PatchManager.createPatch(ui);
            p.setReview(this.getReview());
            PatchReviewCreationHelper.addAllPatchRevsToReview(p, this.getReview());
            return "success";
        }
        catch (Exception e2) {
            Logs.APP_LOG.error((Object)"Error adding patch", (Throwable)e2);
            this.addActionError("Error adding patch: " + e2.getMessage());
            return "error";
        }
    }

    public Iterator getPatchDOs() {
        FilterWrap fl = new FilterWrap(this.getPatches().iterator());
        fl.registerFilter(new Filter(){

            public Object filter(Object source) {
                return new PatchDO((Patch)source);
            }
        });
        return fl;
    }

    public List getFrxs() {
        return this.getReview().getFrxs();
    }

    public boolean isPatchExists() {
        return !this.getPatches().isEmpty();
    }

    public String getEditMode() {
        return "patch";
    }
}

