/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.create;

import com.cenqua.crucible.actions.BaseAction;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.tags.ReviewUtil;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;

public class CreateBlankReviewAction
extends BaseAction {
    private Review review;
    private Project project;

    public void setProjectId(int projectId) {
        this.project = this.projectManager.getProjectById(projectId);
    }

    public void setProjectKey(String projectKey) {
        Project p = this.projectManager.getProjectByKey(projectKey);
        if (p != null) {
            this.project = p;
        }
    }

    public Project getProject() {
        return this.project;
    }

    public String getPermaId() {
        return this.review == null ? "" : this.review.getPermaId();
    }

    public String getActionName() {
        return "createReview";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        try {
            RepositoryHandle defaultRepo;
            Object allProjects;
            this.beginTx();
            if (this.getCurrentUser() == null) {
                this.commitTx();
                String string = "loginRequired";
                return string;
            }
            if (this.project == null && (allProjects = this.getProjectsCanCreateIn()).size() == 1) {
                this.project = (Project)allProjects.get(0);
            }
            if (this.project == null) {
                this.commitTx();
                allProjects = "selectProject";
                return allProjects;
            }
            if (!ReviewUtil.principalCanDoProjectAction(this.getPrincipal(), "action:createReview", this.project)) {
                this.addActionMessage("You do not have permission to create reviews in project " + this.project.getName());
                this.commitTx();
                allProjects = "selectProject";
                return allProjects;
            }
            this.review = ReviewManager.createReviewWithDefaults(this.projectManager, this.project, "");
            this.review.setDescription("");
            this.review.setAuthor(this.getCurrentUser());
            if (this.review.getModerator() == null) {
                this.review.setModerator(this.getCurrentUser());
            }
            this.review.setCreator(this.getCurrentUser());
            if (this.review.getRepoName() == null && (defaultRepo = this.getDefaultRepo()) != null) {
                this.review.setRepoName(defaultRepo.getName());
            }
            this.commitTx();
            Logs.APP_LOG.debug((Object)("Created review " + this.review.getPermaId()));
            String string = "done";
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }
}

