/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.create;

import com.cenqua.crucible.actions.create.EditRevisionsAction;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.ChangelogExplorer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class EditChangelogAction
extends EditRevisionsAction {
    private static final int TRUNCATE_CHANGESET_SIZE = 100;
    private RecentChangesDO recentChanges;
    private ChangelogExplorer explorer;
    private String fromid;
    private String toid;
    private boolean inc;

    public String getEditMode() {
        return "changelog";
    }

    public void setFromid(String fromid) {
        this.fromid = fromid;
    }

    public void setToid(String toid) {
        this.toid = toid;
    }

    public ChangelogExplorer getExplorer() throws Exception {
        this.initChangesets();
        return this.explorer;
    }

    public RecentChangesDO getRecentChanges() throws Exception {
        this.initChangesets();
        return this.recentChanges;
    }

    public void setInc(boolean inc) {
        this.inc = inc;
    }

    private void initChangesets() throws DbException {
        if (this.recentChanges == null && this.isRepositoryAvailable()) {
            RevisionCache cache = ((RepositorySource)this.getSource()).getRepoEngine().getRevisionCache();
            this.explorer = new ChangelogExplorer(this.getPathInfo().getLocalPath(), cache, this.wbSpec);
            if (!StringUtil.nullOrEmpty(this.fromid)) {
                this.explorer.setFromChangeSetId(this.fromid);
                this.explorer.setFromChangeSetIdInc(this.inc);
            } else if (!StringUtil.nullOrEmpty(this.toid)) {
                this.explorer.setToChangeSetId(this.toid);
                this.explorer.setToChangeSetIdInc(this.inc);
            }
            this.explorer.computeData(30);
            List changesets = this.explorer.getChangesets();
            this.recentChanges = new RecentChangesDO(changesets);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RecentChangesDO {
        private final List<ChangeSetDO> changesetInfos;

        public RecentChangesDO(List<ChangeSet> changesets) {
            this.changesetInfos = new ArrayList<ChangeSetDO>(changesets.size());
            for (ChangeSet changeset : changesets) {
                ChangeSetDO csdo = new ChangeSetDO(changeset);
                this.changesetInfos.add(csdo);
            }
        }

        public List<ChangeSetDO> getChangeSetInfos() {
            return this.changesetInfos;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ChangeSetDO {
        private final ChangeSet changeSet;
        private boolean allItemsInReview;
        private boolean someItemsInReview;
        private final List<ChangeSetItemDO> items = new LinkedList<ChangeSetItemDO>();
        private boolean truncated;
        private int totalSize;

        public ChangeSetDO(ChangeSet cs) {
            this.changeSet = cs;
            this.setupItems();
        }

        private void setupItems() {
            if (EditChangelogAction.this.getCreateHelper() == null) {
                Logs.APP_LOG.warn((Object)("ChangeSetDO setup items failed because " + EditChangelogAction.this.getSource().getReason()));
                return;
            }
            try {
                int itemCount;
                this.totalSize = itemCount = this.changeSet.getRevisionInfosCount();
                int inThisIterCount = 0;
                for (int i2 = 0; i2 < itemCount; ++i2) {
                    if (i2 >= 100) {
                        this.truncated = true;
                        break;
                    }
                    FileRevision fr = this.changeSet.getRevisionInfo(i2);
                    boolean inThisIter = EditChangelogAction.this.getCreateHelper().inThisIteration(fr.getRevInfoKey());
                    this.items.add(new ChangeSetItemDO(fr, inThisIter));
                    if (!inThisIter) continue;
                    this.someItemsInReview = true;
                    ++inThisIterCount;
                }
                if (inThisIterCount == itemCount) {
                    this.allItemsInReview = true;
                    this.someItemsInReview = false;
                }
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)"Unexpected problem getting revisions", (Throwable)e2);
            }
        }

        public ChangeSet getChangeSet() {
            return this.changeSet;
        }

        public boolean isAllItemsInReview() {
            return this.allItemsInReview;
        }

        public boolean isSomeItemsInReview() {
            return this.someItemsInReview;
        }

        public boolean isTruncated() {
            return this.truncated;
        }

        public void setTruncated(boolean truncated) {
            this.truncated = truncated;
        }

        public int getTotalSize() {
            return this.totalSize;
        }

        public void setTotalSize(int totalSize) {
            this.totalSize = totalSize;
        }

        public List<ChangeSetItemDO> getItems() {
            return this.items;
        }
    }

    public class ChangeSetItemDO {
        private final FileRevision revision;
        private final boolean inThisIteration;

        public ChangeSetItemDO(FileRevision revision, boolean inThisIteration) {
            this.revision = revision;
            this.inThisIteration = inThisIteration;
        }

        public FileRevision getFileRevision() {
            return this.revision;
        }

        public boolean isInThisIteration() {
            return this.inThisIteration;
        }
    }
}

