/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.create;

import com.cenqua.crucible.actions.ConstraintExplorer;
import com.cenqua.crucible.actions.PathInfoBaseAction;
import com.cenqua.crucible.actions.create.RepoNameSelectHelper;
import com.cenqua.crucible.filters.CrucibleFilter;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.revision.source.RepositorySource;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.crucible.revision.source.SourceException;
import com.cenqua.crucible.util.ReviewCreationHelper;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cvsrep.search.SearchManager;
import com.cenqua.fisheye.cvsrep.search.SearchResults;
import com.cenqua.fisheye.cvsrep.search.query.FishQuery;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.util.CompareUtil;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.FishEyePathInfo;
import com.cenqua.fisheye.web.UserProfile;
import com.cenqua.fisheye.web.UserProfileManager;
import com.cenqua.fisheye.web.WaybackSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EditRevisionsAction
extends PathInfoBaseAction
implements ConstraintExplorer {
    protected WaybackSpec wbSpec;
    private ReviewCreationHelper createHelper;
    protected String command;
    private String repoName;
    private Source source;
    private String search;

    protected ReviewCreationHelper getCreateHelper() {
        if (this.createHelper == null && this.getSource().isAvailable()) {
            try {
                this.createHelper = new ReviewCreationHelper((RepositorySource)this.getSource(), this.getReview());
            }
            catch (SourceException e2) {
                Logs.APP_LOG.warn((Object)e2);
            }
        }
        return this.createHelper;
    }

    public abstract String getEditMode();

    public void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public void setRepoName(String repoName) {
        this.repoName = RepoNameSelectHelper.convertSentinelToNull(repoName);
    }

    @Override
    public WaybackSpec getWbSpec() {
        return this.wbSpec;
    }

    public String getRepoName() {
        return RepoNameSelectHelper.convertNullToSentinel(this.getReview().getRepoName());
    }

    public boolean isUsingRepo() {
        return this.getReview().getRepoName() != null;
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    protected String getScmAuthor(String repname, CrucibleUser author) {
        if (author == null) {
            return null;
        }
        if (repname == null) {
            return null;
        }
        String username = author.getUserName();
        try {
            UserProfileManager upm = AppConfig.getsConfig().getUserProfileManager();
            UserProfile up = upm.getProfile(username);
            UserProfile.AuthorMappings mappings = up.getAuthorMappings();
            String mapping = mappings.getAuthorForRep(repname);
            if (mapping != null) {
                return mapping;
            }
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"problem retrieving user profile", (Throwable)e2);
        }
        try {
            List<String> authors;
            Source s = CrucibleFilter.getSource(Source.getRepoSourceName(repname));
            if (s instanceof RepositorySource && s.isAvailable() && (authors = ((RepositorySource)s).getRepoEngine().getRevisionCache().findAuthors(new Path())).contains(username)) {
                return username;
            }
        }
        catch (Exception e3) {
            Logs.APP_LOG.warn((Object)"problem checking username", (Throwable)e3);
        }
        return null;
    }

    public Source getSource() {
        String repName;
        if (this.source == null && (repName = this.getPathInfo().getRepname()) != null) {
            this.source = CrucibleFilter.getSource(Source.getRepoSourceName(repName));
            if (!this.source.isAvailable()) {
                this.addActionError(this.source.getReason());
            }
        }
        return this.source;
    }

    public boolean isRepositoryAvailable() {
        return this.getSource() instanceof RepositorySource && this.getSource().isAvailable();
    }

    public Path getFullPath() {
        return this.getPathInfo().getFullPath();
    }

    @Override
    public List getAvailableAuthors() {
        ArrayList<String> authors = new ArrayList<String>();
        try {
            WaybackSpec wb;
            FishEyePathInfo pi = this.getPathInfo();
            if (this.isRepositoryAvailable()) {
                List<String> a2 = ((RepositorySource)this.getSource()).getRepoEngine().getRevisionCache().findAuthors(pi.getLocalPath());
                authors.addAll(a2);
            }
            if ((wb = this.getWbSpec()) != null && wb.getAuthor() != null && !authors.contains(wb.getAuthor())) {
                authors.add(0, wb.getAuthor());
            }
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"Unexpected problem getting Authors for constraint", (Throwable)e2);
        }
        return authors;
    }

    @Override
    public List getAvailableBranches() {
        ArrayList<String> branches = new ArrayList<String>();
        try {
            WaybackSpec wb;
            FishEyePathInfo pi = this.getPathInfo();
            if (this.isRepositoryAvailable()) {
                List<String> b2 = ((RepositorySource)this.getSource()).getRepoEngine().getRevisionCache().findBranches(pi.getLocalPath());
                branches.addAll(b2);
            }
            if ((wb = this.getWbSpec()) != null && wb.getBranch() != null && !branches.contains(wb.getBranch())) {
                branches.add(0, wb.getBranch());
            }
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"Unexpected problem getting Branches for constraint", (Throwable)e2);
        }
        return branches;
    }

    private void log(String message) {
        LogManager.log(this.getCurrentUser().getDisplayName() + " altering " + this.getReview().getPermaId() + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        try {
            this.beginTx();
            if (this.command != null) {
                if ("setRepo".equals(this.command)) {
                    if (!CompareUtil.equals(this.repoName, this.getReview().getRepoName())) {
                        this.log(" changing repository to \"" + this.repoName + "\"");
                        this.getReview().setRepoName(this.repoName);
                        this.command = "successRedirect";
                    }
                } else if ("addSearch".equals(this.command) && !StringUtil.nullOrEmpty(this.search)) {
                    this.log(" adding search " + this.search);
                    Collection<FileRevision> revs = this.searchForRevisions(this.search);
                    this.getCreateHelper().addRevisions(this.getCurrentUser(), revs, true);
                    this.command = this.doView();
                }
            } else {
                this.command = this.doView();
            }
            this.commitTx();
            String string = this.command;
            return string;
        }
        finally {
            this.rollbackTxIfNotCommited();
        }
    }

    private Collection<FileRevision> searchForRevisions(String eyeQL) {
        SearchManager searcher = ((RepositorySource)this.getSource()).getRepoEngine().getSearchManager();
        ArrayList<String> errors = new ArrayList<String>();
        FishQuery query = FishQuery.parse(eyeQL, errors);
        if (!errors.isEmpty()) {
            for (String error : errors) {
                this.addActionError(error);
            }
            return new ArrayList<FileRevision>();
        }
        try {
            SearchResults results = searcher.runQuery(query, false);
            ArrayList<FileRevision> revisions = new ArrayList<FileRevision>(results.size());
            SearchResults.RevisionResultsIterator it = results.iterateRevisions(0);
            while (it.hasNext()) {
                revisions.add((FileRevision)it.next());
            }
            return revisions;
        }
        catch (Exception e2) {
            this.addActionError("Error executing search '" + eyeQL + "': " + e2);
            return new ArrayList<FileRevision>();
        }
    }

    protected String doView() {
        FishEyePathInfo pi = this.getPathInfo();
        this.wbSpec = WaybackSpec.fromPathInfo(pi);
        if (this.wbSpec == null) {
            this.wbSpec = new WaybackSpec();
        }
        if (pi.isEmpty() && this.getReview().getRepoName() != null) {
            String repname = pi.getRepname();
            if (repname == null) {
                repname = this.getReview().getRepoName();
            }
            if (this.wbSpec.getAuthor() == null) {
                String author = this.getScmAuthor(repname, this.getReview().getAuthor());
                this.wbSpec.setAuthor(author);
            }
            this.setActionPathInfo(this.wbSpec.getUrlCommand() + "/" + repname + "/" + pi.getLocalPath());
            return "successRedirect";
        }
        if (this.handleWaybackJump()) {
            return "successRedirect";
        }
        this.getSource();
        return "success";
    }
}

