/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.actions.search.comment;

import com.cenqua.crucible.configuration.metrics.FieldDefinition;
import com.cenqua.crucible.configuration.metrics.MetricsConfig;
import com.cenqua.crucible.configuration.metrics.MetricsManager;
import com.cenqua.crucible.model.PermaIdFormatException;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.reports.Period;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentSearchData {
    private Integer projectId;
    private String text;
    private boolean defects;
    private boolean comments;
    private String[] state;
    private String authorName;
    private Period period = new Period();
    private boolean notDeleted = true;
    private Map<String, ArrayList<MetricDO>> metricsByName = new HashMap<String, ArrayList<MetricDO>>();
    private Map<Integer, MetricDO> metricsById = new HashMap<Integer, MetricDO>();
    MetricsConfig metricsConfig;
    private Review owningReview;
    private String permaId;

    public CommentSearchData() {
        this.makeMetrics();
    }

    private void makeMetrics() {
        MetricsConfig mc = MetricsManager.INSTANCE.getConfig(MetricsManager.INSTANCE.getLatestVersion());
        if (mc != null && mc.isValid()) {
            int i2 = 0;
            for (FieldDefinition fd : mc.getCommentFields().values()) {
                for (Map.Entry<String, Object> entry : fd.getNamedEntries()) {
                    if (!fd.isExclusiveSet()) continue;
                    MetricDO mdo = new MetricDO(i2, fd.getName(), entry.getKey(), (Integer)entry.getValue(), false);
                    this.addToMaps(mdo);
                    ++i2;
                }
            }
        }
    }

    private void addToMaps(MetricDO mdo) {
        ArrayList<MetricDO> metricDOs = this.metricsByName.get(mdo.getMetricName());
        if (metricDOs == null) {
            metricDOs = new ArrayList();
            this.metricsByName.put(mdo.getMetricName(), metricDOs);
        }
        metricDOs.add(mdo);
        this.metricsById.put(mdo.getId(), mdo);
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isDefects() {
        return this.defects;
    }

    public void setDefects(boolean defects) {
        this.defects = defects;
    }

    public boolean isComments() {
        return this.comments;
    }

    public void setComments(boolean comments) {
        this.comments = comments;
    }

    public String[] getState() {
        return this.state;
    }

    public void setState(String[] state) {
        this.state = state;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    public Collection<MetricDO> getMetrics() {
        return this.metricsById.values();
    }

    public Map<String, ArrayList<MetricDO>> getMetricsByName() {
        return this.metricsByName;
    }

    public Set<Map.Entry<String, ArrayList<MetricDO>>> getMetricEntriesByName() {
        return this.metricsByName.entrySet();
    }

    public void setMetric(Integer id, boolean value) {
        MetricDO mdo = this.metricsById.get(id);
        if (mdo != null) {
            mdo.setSelected(value);
        }
    }

    public void setMetric(Integer[] metric) {
        if (metric != null) {
            for (Integer id : metric) {
                MetricDO mdo = this.metricsById.get(id);
                if (mdo == null) continue;
                mdo.setSelected(true);
            }
        }
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public boolean isNotDeleted() {
        return this.notDeleted;
    }

    public Review getReview() {
        return this.owningReview;
    }

    public void setReview(Review review) {
        this.owningReview = review;
    }

    public String getPermaId() {
        return this.permaId;
    }

    public void setPermaId(String permaId) {
        this.permaId = permaId;
        if (permaId == null) {
            return;
        }
        try {
            Review r = ReviewManager.getReviewByPermaId(permaId);
            this.setReview(r);
        }
        catch (PermaIdFormatException permaIdFormatException) {
            // empty catch block
        }
    }

    public class MetricDO {
        private Integer id;
        private String metricName;
        private String fieldName;
        private Integer fieldId;
        private boolean selected = false;

        public MetricDO(Integer id, String metricName, String fieldName, Integer fieldId, boolean selected) {
            this.id = id;
            this.metricName = metricName;
            this.fieldName = fieldName;
            this.fieldId = fieldId;
            this.selected = selected;
        }

        public Integer getId() {
            return this.id;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Integer getFieldId() {
            return this.fieldId;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }
    }
}

