/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.hibernate;

import com.cenqua.crucible.fisheye.CrucibleReindexMessage;
import com.cenqua.crucible.model.FileRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.revision.source.Source;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.CompareUtil;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.type.Type;

public class AuditInterceptor
extends EmptyInterceptor {
    private Session session;
    private Set<String> repnames = new HashSet<String>();
    private final Map<Review, Set<FileRevision>> changedRevisions = new LinkedHashMap<Review, Set<FileRevision>>();

    public void setSession(Session session) {
        this.session = session;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        if (entity instanceof FileRevisionExtraInfo) {
            FileRevisionExtraInfo frx = (FileRevisionExtraInfo)entity;
            this.frxChanged(frx, propertyNames, currentState, previousState);
        }
        if (entity instanceof Review) {
            Review review = (Review)entity;
            this.reviewChanged(review, currentState, previousState, propertyNames);
        }
        return false;
    }

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        if (entity instanceof FileRevisionExtraInfo) {
            FileRevisionExtraInfo frx = (FileRevisionExtraInfo)entity;
            this.frxChanged(frx, propertyNames, state, null);
        }
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        if (entity instanceof FileRevisionExtraInfo) {
            FileRevisionExtraInfo frx = (FileRevisionExtraInfo)entity;
            this.frxChanged(frx, propertyNames, state, null);
        }
        return false;
    }

    public void afterTransactionCompletion(Transaction transaction) {
        if (this.repnames.isEmpty()) {
            return;
        }
        RepositoryManager rm = AppConfig.getsConfig().getRepositoryManager();
        for (String repname : this.repnames) {
            RepositoryHandle rh = rm.getRepository(repname);
            if (rh == null) {
                Logs.APP_LOG.warn((Object)("could not find repository " + repname));
                continue;
            }
            Logs.APP_LOG.debug((Object)("Requesting Crucible scan for " + rh.getName()));
            rh.requestCrucibleIncrementalScan();
        }
    }

    private void reviewChanged(Review review, Object[] currentState, Object[] previousState, String[] propertyNames) {
        for (int i2 = 0; i2 < propertyNames.length; ++i2) {
            String prevState;
            String newState;
            String prop = propertyNames[i2];
            if (!"stateName".equals(prop) || CompareUtil.equals(newState = (String)currentState[i2], prevState = (String)previousState[i2])) continue;
            this.reviewStateChanged(review);
        }
    }

    private void frxChanged(FileRevisionExtraInfo frx, String[] propertyNames, Object[] currentState, Object[] previousState) {
        Review review = frx.getReview();
        for (int i2 = 0; i2 < propertyNames.length; ++i2) {
            String prop = propertyNames[i2];
            if (!"frr".equals(prop)) continue;
            this.updatedFrr(review, (FileRevisionExtraInfo)currentState[i2]);
            if (previousState == null) continue;
            this.updatedFrr(review, (FileRevisionExtraInfo)previousState[i2]);
        }
    }

    private void reviewStateChanged(Review review) {
        for (FileRevisionExtraInfo frx : review.getFrxs()) {
            this.updatedFrr(review, frx);
        }
    }

    private void updatedFrr(Review review, FileRevisionExtraInfo frr) {
        if (frr == null) {
            Logs.APP_LOG.warn((Object)"FRX has null frr");
            return;
        }
        if (review == null) {
            Logs.APP_LOG.warn((Object)"FRX has null review");
            return;
        }
        FileRevision fr = frr.getFileRevision();
        if (fr == null) {
            Logs.APP_LOG.warn((Object)"frr had null file revision");
            return;
        }
        String sourceName = fr.getSourceName();
        if (!Source.isRepositorySource(sourceName)) {
            return;
        }
        Set<FileRevision> alreadySeen = this.changedRevisions.get(review);
        if (alreadySeen == null) {
            alreadySeen = new HashSet<FileRevision>();
            this.changedRevisions.put(review, alreadySeen);
        }
        if (alreadySeen.contains(fr)) {
            return;
        }
        alreadySeen.add(fr);
        String repname = Source.getRepositorySourceIdentifier(sourceName);
        if (Logs.APP_LOG.isDebugEnabled()) {
            Logs.APP_LOG.debug((Object)("log fr update " + review.getPermaId() + " " + repname + " " + fr.getRevInfoKey()));
        }
        this.repnames.add(repname);
        CrucibleReindexMessage update = new CrucibleReindexMessage();
        update.setReview(review);
        update.setFileRevision(fr);
        this.session.save((Object)update);
    }
}

