/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model;

import com.cenqua.crucible.configuration.metrics.MetricsManager;
import com.cenqua.crucible.model.CommentList;
import com.cenqua.crucible.model.CommonListMixin;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.CustomFieldList;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.RevisionComment;
import com.cenqua.crucible.model.managers.CommentManager;
import java.util.Date;
import java.util.HashMap;

public class Comment
extends CommonListMixin
implements CommentList,
CustomFieldList {
    public static final String PERMAID_PREFIX = "CMT:";
    private String message = null;
    private boolean draft = false;
    private boolean deleted = false;
    private boolean defectRaised = false;
    private boolean defectApproved = false;
    private CrucibleUser user = null;
    private Integer id;
    private Date createDate;
    private Review review;
    private Comment replyToComment;
    private RevisionComment revisionComment;

    public Comment() {
        this.setCreateDate(new Date());
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getId() {
        return this.id;
    }

    public String getPermaId() {
        return PERMAID_PREFIX + this.id;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean getDraft() {
        return this.draft;
    }

    public void setDraft(boolean draft) {
        this.draft = draft;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean getDefectRaised() {
        return this.defectRaised;
    }

    public void setDefectRaised(boolean defectRaised) {
        this.defectRaised = defectRaised;
    }

    public boolean isDefectRaised() {
        return this.defectRaised;
    }

    public boolean isDefectApproved() {
        return this.defectApproved;
    }

    public void setDefectApproved(boolean defectApproved) {
        this.defectApproved = defectApproved;
    }

    public CrucibleUser getUser() {
        return this.user;
    }

    public void setUser(CrucibleUser user) {
        this.user = user;
    }

    public Review getReview() {
        return this.review;
    }

    public void setReview(Review review) {
        this.review = review;
    }

    public Comment getReplyToComment() {
        return this.replyToComment;
    }

    public void setReplyToComment(Comment replyToComment) {
        this.replyToComment = replyToComment;
    }

    public boolean isReviewComment() {
        return this.getReview().getComments().contains(this);
    }

    public boolean isRevision() {
        return !this.isReply() && !this.isReviewComment();
    }

    public boolean isReply() {
        return this.getReplyToComment() != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null) {
            return false;
        }
        if (o == null || !(o instanceof Comment)) {
            return false;
        }
        Integer oid = ((Comment)o).getId();
        return oid != null && this.id.equals(oid);
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public Integer getMetricsVersion() {
        return this.getReview().getMetricsVersion();
    }

    public RevisionComment getRevisionComment() {
        if (this.revisionComment == null) {
            this.revisionComment = CommentManager.findRevisionComment(this);
        }
        return this.revisionComment;
    }

    public HashMap getFieldDefinitions() {
        if (this.getMetricsVersion() != null) {
            return MetricsManager.INSTANCE.getConfig(this.getMetricsVersion()).getCommentFields();
        }
        return new HashMap();
    }

    public boolean isNegative() {
        return this.isDefectRaised();
    }

    public boolean isPositive() {
        return !this.isNegative();
    }

    public String toString() {
        return super.toString() + "(" + this.getId() + ": " + this.getUser().getUserName() + ", " + this.getCreateDate() + (this.isDraft() ? ", Draft" : "") + (this.isDefectRaised() ? ", Defect" : "") + ", " + this.getMessage() + ")";
    }
}

