/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.actions.search.comment.CommentSearchData;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.Comment;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.RevisionComment;
import com.cenqua.crucible.model.managers.LogManager;
import com.cenqua.crucible.notification.NotificationManager;
import com.cenqua.crucible.reports.Period;
import com.cenqua.crucible.reports.commentsDefects.DefectReportDO;
import com.cenqua.crucible.util.HqlUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.util.DateHelper;
import com.cenqua.fisheye.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.hibernate.Query;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentManager {
    private static Session session() {
        return HibernateUtil.currentSession();
    }

    public static Comment createComment(String message, Review review, CrucibleUser user) {
        Comment c2 = new Comment();
        c2.setMessage(message);
        c2.setUser(user);
        c2.setReview(review);
        CommentManager.session().save((Object)c2);
        return c2;
    }

    public static Comment getById(Integer id) {
        return (Comment)CommentManager.session().get(Comment.class, (Serializable)id);
    }

    public static List getComments() {
        return CommentManager.session().createQuery("from Comment").list();
    }

    public static void deleteComment(Comment comment) {
        CommentManager.session().delete((Object)comment);
    }

    public static List<Comment> getUserReviewDraftComments(Review review, CrucibleUser user) {
        return CommentManager.getReviewComments(review, user, true, null, null);
    }

    public static List<Comment> getReviewComments(Review review, CrucibleUser user, Boolean draft, Boolean deleted, Boolean defect) {
        Query q = CommentManager.session().createQuery("select comment from Comment comment where :review = comment.review and " + (user != null ? "comment.user = :user and " : "") + (defect != null ? "comment.defectRaised = :defect and " : "") + (deleted != null ? "comment.deleted = :deleted and " : "") + (draft != null ? "comment.draft = :draft" : ""));
        q.setEntity("review", (Object)review);
        if (defect != null) {
            q.setBoolean("defect", defect.booleanValue());
        }
        if (deleted != null) {
            q.setBoolean("deleted", deleted.booleanValue());
        }
        if (draft != null) {
            q.setBoolean("draft", draft.booleanValue());
        }
        if (user != null) {
            q.setEntity("user", (Object)user);
        }
        return q.list();
    }

    public static int countDraftComments(Review review, CrucibleUser user) {
        return CommentManager.getReviewCommentCount(review, user, Boolean.TRUE, Boolean.FALSE, null);
    }

    public static int getReviewCommentCount(Review review, CrucibleUser user, Boolean draft, Boolean deleted, Boolean defect) {
        Query q = CommentManager.session().createQuery("select count(distinct comment.id) from Comment comment where :review = comment.review and " + (user != null ? "comment.user = :user and " : "") + (defect != null ? "comment.defectRaised = :defect and " : "") + (deleted != null ? "comment.deleted = :deleted and " : "") + (draft != null ? "comment.draft = :draft" : ""));
        q.setEntity("review", (Object)review);
        if (defect != null) {
            q.setBoolean("defect", defect.booleanValue());
        }
        if (deleted != null) {
            q.setBoolean("deleted", deleted.booleanValue());
        }
        if (draft != null) {
            q.setBoolean("draft", draft.booleanValue());
        }
        if (user != null) {
            q.setEntity("user", (Object)user);
        }
        return ((Long)q.uniqueResult()).intValue();
    }

    public static int countReviewGeneralComment(Review review, CrucibleUser user, Boolean draft, Boolean deleted, Boolean defect) {
        Query q = CommentManager.session().createQuery("select count(distinct comment.id) from Review review join review.comments comment where :review = review and " + (user != null ? "comment.user = :user and " : "") + (defect != null ? "comment.defectRaised = :defect and " : "") + (deleted != null ? "comment.deleted = :deleted and " : "") + (draft != null ? "comment.draft = :draft" : ""));
        q.setEntity("review", (Object)review);
        if (defect != null) {
            q.setBoolean("defect", defect.booleanValue());
        }
        if (deleted != null) {
            q.setBoolean("deleted", deleted.booleanValue());
        }
        if (draft != null) {
            q.setBoolean("draft", draft.booleanValue());
        }
        if (user != null) {
            q.setEntity("user", (Object)user);
        }
        return ((Long)q.uniqueResult()).intValue();
    }

    public static int getReviewFrxsCommentCount(Review review, CrucibleUser user, Boolean draft, Boolean deleted, Boolean defect) {
        Query q = CommentManager.session().createQuery("select count(distinct rc.comment.id) from Review review join review.frxs frx join frx.revisionComments rc where :review = review and " + (user != null ? "rc.comment.user = :user and " : "") + (defect != null ? "rc.comment.defectRaised = :defect and " : "") + (deleted != null ? "rc.comment.deleted = :deleted and " : "") + (draft != null ? "rc.comment.draft = :draft" : ""));
        q.setEntity("review", (Object)review);
        if (defect != null) {
            q.setBoolean("defect", defect.booleanValue());
        }
        if (deleted != null) {
            q.setBoolean("deleted", deleted.booleanValue());
        }
        if (draft != null) {
            q.setBoolean("draft", draft.booleanValue());
        }
        if (user != null) {
            q.setEntity("user", (Object)user);
        }
        return ((Long)q.uniqueResult()).intValue();
    }

    public static Collection<Comment> getRevisionCommentComments(Review review) {
        List<Comment> l = Collections.checkedList(new ArrayList(), Comment.class);
        l.addAll(CommentManager.getRevisionComments("rc.comment", review));
        return l;
    }

    public static List<RevisionComment> getRevisionComments(Review review) {
        return CommentManager.getRevisionComments("rc", review);
    }

    private static List getRevisionComments(String selector, Review review) {
        Query q = CommentManager.session().createQuery("select " + selector + " from FileRevisionExtraInfo frx join frx.revisionComments rc " + "where frx.frr.review = :review");
        q.setEntity("review", (Object)review);
        return q.list();
    }

    public static RevisionComment findRevisionComment(Comment comment) {
        if (comment.isRevision()) {
            Query q = CommentManager.session().createQuery("Select rc from FileRevisionExtraInfo frx join frx.revisionComments rc where rc.comment = :comment");
            q.setEntity("comment", (Object)comment);
            return (RevisionComment)HqlUtil.getFirstResultOrNull(q);
        }
        return null;
    }

    public static List searchComments(String term, CrucibleUser user, String selector) {
        boolean draft = false;
        String where = null;
        where = HqlUtil.whereBuilder(where, "lower(comment.message) like :term", "or");
        where = HqlUtil.whereBuilder(where, "lower(comment.user.userName) like :term", "or");
        if ("defect".equals(term)) {
            where = HqlUtil.whereBuilder(where, "comment.defectRaised = true", "or");
            where = HqlUtil.whereBuilder(where, "comment.defectApproved = true", "or");
        }
        if ("draft".equals(term)) {
            draft = true;
            where = HqlUtil.whereBuilder(where, "comment.draft = true and comment.user = :user", "or");
        }
        String qstr = "select " + selector + " " + "from Comment comment " + where + " order by comment.review.id desc";
        Query q = CommentManager.session().createQuery(qstr);
        if (draft) {
            q.setEntity("user", (Object)user);
        }
        q.setString("term", "%" + term + "%");
        return q.list();
    }

    public static List searchComments(CommentSearchData searchData, String selector) {
        int i2;
        String where = "";
        where = HqlUtil.whereBuilder(where, "comment.draft = false", "and");
        if (searchData.getPeriod().getFrom() != null) {
            where = HqlUtil.whereBuilder(where, "comment.createDate >= :from", "and");
        }
        if (searchData.getPeriod().getTo() != null) {
            where = HqlUtil.whereBuilder(where, "comment.createDate <= :to", "and");
        }
        if (!StringUtil.nullOrEmpty(searchData.getText())) {
            where = HqlUtil.whereBuilder(where, "comment.message like :message", "and");
        }
        if (!StringUtil.nullOrEmpty(searchData.getAuthorName())) {
            where = HqlUtil.whereBuilder(where, "comment.user.userName = :user", "and");
        }
        if (searchData.getProjectId() != null) {
            where = HqlUtil.whereBuilder(where, "comment.review.project.id = :project", "and");
        }
        if (searchData.getReview() != null) {
            where = HqlUtil.whereBuilder(where, "comment.review = :review", "and");
        }
        if (searchData.getState() != null && searchData.getState().length > 0) {
            for (i2 = 0; i2 < searchData.getState().length; ++i2) {
                String stateName = searchData.getState()[i2];
                where = HqlUtil.whereBuilder(where, (i2 == 0 ? "(" : "") + "comment.review.stateName = '" + stateName + "'", i2 == 0 ? "and" : "or");
            }
            where = where + ") ";
        }
        if (searchData.isComments() && !searchData.isDefects()) {
            where = HqlUtil.whereBuilder(where, "comment.defectRaised != true", "and");
        }
        if (!searchData.isComments() && searchData.isDefects()) {
            where = HqlUtil.whereBuilder(where, "comment.defectRaised = true", "and");
        }
        if (searchData.isNotDeleted()) {
            where = HqlUtil.whereBuilder(where, "comment.deleted = false", "and");
        }
        i2 = 0;
        for (CommentSearchData.MetricDO mdo : searchData.getMetrics()) {
            if (!mdo.isSelected()) continue;
            where = HqlUtil.whereBuilder(where, "field" + ++i2 + ".name = '" + mdo.getMetricName() + "'", "and");
            where = HqlUtil.whereBuilder(where, "field" + i2 + ".intVal = " + mdo.getFieldId(), "and");
        }
        String qstr = "select " + selector + " " + "from Comment comment ";
        for (int j = 1; j <= i2; ++j) {
            qstr = qstr + "join comment.fieldList field" + j + " ";
        }
        qstr = qstr + where;
        Query q = CommentManager.session().createQuery(qstr);
        if (searchData.getPeriod().getFrom() != null) {
            q.setTimestamp("from", searchData.getPeriod().getFrom());
        }
        if (searchData.getPeriod().getTo() != null) {
            q.setTimestamp("to", searchData.getPeriod().getTo());
        }
        if (!StringUtil.nullOrEmpty(searchData.getText())) {
            q.setString("message", "%" + searchData.getText() + "%");
        }
        if (!StringUtil.nullOrEmpty(searchData.getAuthorName())) {
            System.out.println(":user == " + searchData.getAuthorName());
            q.setString("user", searchData.getAuthorName());
        }
        if (searchData.getProjectId() != null) {
            q.setInteger("project", searchData.getProjectId().intValue());
        }
        if (searchData.getReview() != null) {
            q.setEntity("review", (Object)searchData.getReview());
        }
        return q.list();
    }

    public static long countCommentsOnDay(Date day, boolean defects, Project project) {
        TimeZone tz = AppConfig.getsConfig().getTimezone();
        return CommentManager.countComments(DateHelper.getStartOfDay(day, tz), DateHelper.getEndOfDay(day, tz), defects, project);
    }

    public static long countComments(Date from, Date to, boolean defects, Project project) {
        String where = null;
        where = HqlUtil.whereBuilder(where, "review.project = :project", "and");
        where = HqlUtil.whereBuilder(where, "comment.createDate >= :from", "and");
        where = HqlUtil.whereBuilder(where, "comment.createDate < :to", "and");
        where = HqlUtil.whereBuilder(where, "comment.draft = false", "and");
        where = HqlUtil.whereBuilder(where, "comment.deleted = false", "and");
        if (defects) {
            where = HqlUtil.whereBuilder(where, "(comment.defectRaised = true", "and");
            where = HqlUtil.whereBuilder(where, "comment.defectApproved = true)", "or");
        } else {
            where = HqlUtil.whereBuilder(where, "(comment.defectRaised = false", "and");
            where = HqlUtil.whereBuilder(where, "comment.defectApproved = false)", "and");
        }
        String qstr = "select count(distinct comment.id) from Comment comment join comment.review review " + where;
        Query q = CommentManager.session().createQuery(qstr);
        q.setTimestamp("to", to);
        q.setTimestamp("from", from);
        q.setEntity("project", (Object)project);
        return (Long)q.uniqueResult();
    }

    public static void publishComment(Comment comment) {
        comment.setDraft(false);
        if (comment.getReplyToComment() != null) {
            NotificationManager.INSTANCE.noteReplied(comment.getReview(), comment.getReplyToComment(), comment);
        } else {
            NotificationManager.INSTANCE.noteCommented(comment.getReview(), comment);
        }
        LogManager.log(comment.getReview().getPermaId() + ": " + comment.getUser().getUserName() + " posted comment " + comment.getId());
    }

    public static void publishDraftComments(Review review, CrucibleUser user) {
        List<Comment> comments = CommentManager.getUserReviewDraftComments(review, user);
        for (Comment comment : comments) {
            CommentManager.publishComment(comment);
        }
    }

    public static Collection<CommentPair> createCommentPairs(Collection<RevisionComment> revisionComments) {
        HashMap<Comment, CommentPair> m = new HashMap<Comment, CommentPair>();
        for (RevisionComment rc : revisionComments) {
            Comment c2 = rc.getComment();
            CommentPair rcs = (CommentPair)m.get(c2);
            if (rcs == null) {
                rcs = new CommentPair(c2);
                m.put(c2, rcs);
            }
            if (rc.getRevision().equals(rc.getFrx().getFileRevision())) {
                rcs.setRevisionComment(rc);
                continue;
            }
            rcs.setFromRevisionComment(rc);
        }
        return m.values();
    }

    public static List<DefectReportDO> getDefectReports(Project project, Period period, String metric) {
        ArrayList defectReps = new ArrayList();
        CommentSearchData sd = new CommentSearchData();
        sd.setProjectId(project.getId());
        sd.setPeriod(period);
        sd.setDefects(true);
        return CommentManager.getDefectReports(sd, metric);
    }

    public static List<DefectReportDO> getDefectReports(CommentSearchData sd, String metric) {
        ArrayList<DefectReportDO> defectReps = new ArrayList<DefectReportDO>();
        Collection<CommentSearchData.MetricDO> mdos = sd.getMetrics();
        if (mdos != null) {
            long otherDefects = HqlUtil.getCountFromSet(CommentManager.searchComments(sd, "count(distinct comment.id)"));
            for (CommentSearchData.MetricDO mdo : mdos) {
                if (!mdo.getMetricName().equals(metric)) continue;
                sd.setMetric(mdo.getId(), true);
                DefectReportDO dr = CommentManager.getDefectReport(sd, mdo);
                defectReps.add(dr);
                sd.setMetric(mdo.getId(), false);
                otherDefects -= dr.getCount().longValue();
            }
            defectReps.add(new DefectReportDO(metric, "Unclassified", otherDefects));
        }
        return defectReps;
    }

    public static DefectReportDO getDefectReport(CommentSearchData sd, CommentSearchData.MetricDO mdo) {
        long l = HqlUtil.getCountFromSet(CommentManager.searchComments(sd, "count(distinct comment.id)"));
        return new DefectReportDO(mdo.getMetricName(), mdo.getFieldName(), l);
    }

    public static class CommentPair {
        private Comment comment;
        private RevisionComment revisionComment;
        private RevisionComment fromRevisionComment;

        public CommentPair(Comment comment) {
            this.comment = comment;
        }

        public RevisionComment getRevisionComment() {
            return this.revisionComment;
        }

        public void setRevisionComment(RevisionComment revisionComment) {
            this.revisionComment = revisionComment;
        }

        public RevisionComment getFromRevisionComment() {
            return this.fromRevisionComment;
        }

        public void setFromRevisionComment(RevisionComment fromRevisionComment) {
            this.fromRevisionComment = fromRevisionComment;
        }

        public Comment getComment() {
            return this.comment;
        }
    }
}

