/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.GroupManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.FEUser;
import com.cenqua.fisheye.user.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="crucibleUserManager")
public class CrucibleUserManager
implements GroupManager {
    private static UserManager getFEUserManager() {
        return AppConfig.getsConfig().getUserManager();
    }

    private static Session session() {
        return HibernateUtil.currentSession();
    }

    public static CrucibleUser createUser(String userName) {
        CrucibleUser user = CrucibleUserManager.getUserByName(userName);
        if (user == null) {
            boolean outsideTransaction;
            boolean bl = outsideTransaction = !CrucibleUserManager.session().getTransaction().isActive();
            if (outsideTransaction) {
                HibernateUtil.beginTransaction();
            }
            user = new CrucibleUser();
            user.setUserName(userName);
            CrucibleUserManager.session().save((Object)user);
            if (outsideTransaction) {
                HibernateUtil.commitTransaction();
            }
        }
        return user;
    }

    public static CrucibleUser getUserByName(String userName) {
        if (userName == null) {
            return null;
        }
        Query q = CrucibleUserManager.session().createQuery("Select user from CrucibleUser user where user.userName = :username");
        q.setString("username", userName);
        return (CrucibleUser)q.uniqueResult();
    }

    public void renameUser(String oldname, String newname) {
        CrucibleUser clash = CrucibleUserManager.getUserByName(newname);
        if (clash != null) {
            String destName;
            CrucibleUser destUser;
            boolean found;
            int counter = 1;
            while (!(found = (destUser = CrucibleUserManager.getUserByName(destName = newname + "_old" + counter++)) == null)) {
            }
            clash.setUserName(destName);
            CrucibleUserManager.session().save((Object)clash);
        }
        CrucibleUser user = CrucibleUserManager.getUserByName(oldname);
        user.setUserName(newname);
        CrucibleUserManager.session().save((Object)user);
    }

    public CrucibleUser findUserByName(String userName) throws DbException {
        CrucibleUser cuser = CrucibleUserManager.getUserByName(userName);
        FEUser feuser = CrucibleUserManager.getFEUserManager().getUser(userName);
        if (cuser == null) {
            if (feuser == null) {
                return null;
            }
            cuser = CrucibleUserManager.createUser(userName);
        }
        cuser.setFeuser(feuser);
        return cuser;
    }

    public List<CrucibleUser> getUsers() throws DbException {
        return this.usernamesToUsers(CrucibleUserManager.getFEUserManager().getAllUsernames());
    }

    private List<CrucibleUser> usernamesToUsers(List<String> names) throws DbException {
        ArrayList<CrucibleUser> users = new ArrayList<CrucibleUser>(names.size());
        for (String name : names) {
            users.add(this.findUserByName(name));
        }
        return Collections.unmodifiableList(users);
    }

    public List<CrucibleUser> getActiveUsers() throws DbException {
        return this.usernamesToUsers(CrucibleUserManager.getFEUserManager().getAllCrucibleEnabledUsernames());
    }

    public Collection getUserNames() throws DbException {
        return Collections.unmodifiableList(CrucibleUserManager.getFEUserManager().getAllUsernames());
    }

    public List<CrucibleUser> getGroupOfUsers(String groupName) throws DbException {
        return this.usernamesToUsers(CrucibleUserManager.getFEUserManager().getUsersInGroup(groupName));
    }

    @Override
    public List<String> getPrincipalGroups(Principal p) throws DbException {
        return CrucibleUserManager.getFEUserManager().getGroupsForUser(p.getUserName());
    }
}

