/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.LogItem;
import com.cenqua.crucible.model.StateChangeLog;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogManager {
    private static Session session() {
        return HibernateUtil.currentSession();
    }

    public static void log(String message) {
        Session session = HibernateUtil.currentSession();
        session.save((Object)new LogItem(message));
    }

    public static List<LogItem> getLogs() {
        List logs = LogManager.session().createQuery("from LogItem").list();
        return Collections.checkedList(new LinkedList(logs), LogItem.class);
    }

    public static List<LogItem> getLogs(int limit, boolean desc) {
        Query q = LogManager.session().createQuery("select logItem from LogItem as logItem order by logItem.createDate " + (desc ? "desc" : "asc"));
        q.setMaxResults(limit);
        List logs = q.list();
        return Collections.checkedList(new LinkedList(logs), LogItem.class);
    }

    public static List<LogItem> getLogs(int limit, boolean desc, String like) {
        Query q = LogManager.session().createQuery("select logItem from LogItem as logItem Where logItem.item like :match order by logItem.createDate " + (desc ? "desc" : "asc"));
        q.setString("match", like);
        q.setMaxResults(limit);
        List logs = q.list();
        return Collections.checkedList(new LinkedList(logs), LogItem.class);
    }

    public static void logStateChange(String newState, Integer reviewId) {
        LogManager.session().save((Object)new StateChangeLog(newState, reviewId));
    }

    public static List<StateChangeLog> getStateChanges(boolean descending) {
        Query q = LogManager.session().createQuery("select stateChange from StateChangeLog as stateChange order by stateChange.timeStamp " + (descending ? "desc" : "asc"));
        List logs = q.list();
        return Collections.checkedList(new LinkedList(logs), StateChangeLog.class);
    }

    public static List<StateChangeLog> getStateChanges(Integer reviewId, boolean descending) {
        Query q = LogManager.session().createQuery("select stateChange from StateChangeLog as stateChange Where stateChange.reviewId = :match order by stateChange.timeStamp " + (descending ? "desc" : "asc"));
        q.setInteger("match", reviewId.intValue());
        List logs = q.list();
        return Collections.checkedList(new LinkedList(logs), StateChangeLog.class);
    }
}

