/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.ReviewParticipant;
import java.io.Serializable;
import org.hibernate.Query;
import org.hibernate.Session;

public class ParticipantManager {
    private static Session session() {
        return HibernateUtil.currentSession();
    }

    public static ReviewParticipant getById(Integer id) {
        return (ReviewParticipant)ParticipantManager.session().get(ReviewParticipant.class, (Serializable)id);
    }

    public static ReviewParticipant getByUser(Review review, CrucibleUser user) {
        if (user == null) {
            return null;
        }
        Query q = ParticipantManager.session().createQuery("select p from ReviewParticipant p where p.ruc.review = :review and p.ruc.user = :user ");
        q.setEntity("review", (Object)review);
        q.setEntity("user", (Object)user);
        return (ReviewParticipant)q.uniqueResult();
    }

    public static ReviewParticipant createParticipant(Review review, CrucibleUser user) {
        ReviewParticipant p = ParticipantManager.getByUser(review, user);
        if (p != null) {
            return p;
        }
        p = new ReviewParticipant();
        p.setReview(review);
        p.setUser(user);
        ParticipantManager.session().save((Object)p);
        return p;
    }

    public static void deleteParticipant(ReviewParticipant p) {
        ParticipantManager.session().delete((Object)p);
    }
}

