/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.crucible.model.managers;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleUser;
import com.cenqua.crucible.model.PermissionScheme;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.Role;
import com.cenqua.crucible.model.managers.CrucibleUserManager;
import com.cenqua.crucible.model.managers.GroupManager;
import com.cenqua.crucible.model.principalAssociations.AllUserPA;
import com.cenqua.crucible.model.principalAssociations.AnonymousPA;
import com.cenqua.crucible.model.principalAssociations.GroupPA;
import com.cenqua.crucible.model.principalAssociations.RolePA;
import com.cenqua.crucible.model.principalAssociations.UserPA;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionManager {
    public static final String DEFAULT_PS_NAME = "default";

    private static Session session() {
        return HibernateUtil.currentSession();
    }

    public static void save(Object o) {
        PermissionManager.session().save(o);
    }

    public static void delete(Object o) {
        PermissionManager.session().delete(o);
    }

    public static PermissionScheme createPS(String name) {
        PermissionScheme ps = PermissionManager.findPS(name);
        if (ps == null) {
            ps = new PermissionScheme(name);
            PermissionManager.session().save((Object)ps);
        }
        return ps;
    }

    public static PermissionScheme findPS(String name) {
        Query q = PermissionManager.session().createQuery("select ps from PermissionScheme ps where ps.name = :name");
        q.setString("name", name);
        return (PermissionScheme)q.uniqueResult();
    }

    public static List<PermissionScheme> getPermissionSchemes() {
        Query q = PermissionManager.session().createQuery("from PermissionScheme");
        return Collections.checkedList(new LinkedList(q.list()), PermissionScheme.class);
    }

    public static List<Project> getProjectsUsingPermScheme(PermissionScheme ps) {
        Query q = PermissionManager.session().createQuery("select p from Project p where p.permissionScheme = :ps");
        q.setEntity("ps", (Object)ps);
        return q.list();
    }

    public static boolean canPrincipalDoAction(PermissionScheme scheme, Principal p, String actionName, GroupManager gm, Review review) {
        if (PermissionManager.canPrincipalDoActionOnAllReviews(scheme, p, actionName, gm)) {
            return true;
        }
        if (review != null) {
            CrucibleUser cu = CrucibleUserManager.getUserByName(p.getUserName());
            LinkedList<Role> roles = review.getUsersRoles(cu);
            for (Role role : roles) {
                if (PermissionManager.checkFor(PrincipalAssocs.RolePA.toString(), scheme, role.getName(), actionName) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<String> getSufficientRoles(PermissionScheme scheme, Principal p, String actionName) {
        HashSet<String> sufficientRoles = new HashSet<String>();
        for (RolePA rpa : scheme.getReviewRolePAs()) {
            if (!rpa.getActionName().equals(actionName)) continue;
            sufficientRoles.add(rpa.getPid());
        }
        return sufficientRoles;
    }

    public static boolean canPrincipalDoActionOnAllReviews(PermissionScheme scheme, Principal p, String actionName, GroupManager gm) {
        if (p.equals(Principal.Anonymous.ANON)) {
            RootConfig root = AppConfig.getsConfig();
            return root.getConfig().getSecurity().getAllowAnon() && root.getConfig().getSecurity().getAllowCruAnon() && PermissionManager.checkFor(PrincipalAssocs.AnonymousPA.toString(), scheme, actionName) != null;
        }
        if (PermissionManager.checkFor(PrincipalAssocs.AllUserPA.toString(), scheme, actionName) != null) {
            return true;
        }
        if (PermissionManager.checkFor(PrincipalAssocs.UserPA.toString(), scheme, p.getUserName(), actionName) != null) {
            return true;
        }
        try {
            List<String> groups = gm.getPrincipalGroups(p);
            if (groups != null) {
                for (String group : groups) {
                    if (PermissionManager.checkFor(PrincipalAssocs.GroupPA.toString(), scheme, group, actionName) == null) continue;
                    return true;
                }
            }
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"Problem looking up groups, group based permission skipped (denied).", (Throwable)e2);
        }
        return false;
    }

    private static Object checkFor(String table, PermissionScheme scheme, String actionName) {
        Query q = PermissionManager.session().createQuery("from " + table + " where ps = :ps and actionName = :actionName");
        q.setEntity("ps", (Object)scheme);
        q.setString("actionName", actionName);
        return q.uniqueResult();
    }

    private static Object checkFor(String table, PermissionScheme scheme, String pid, String actionName) {
        Query q = PermissionManager.session().createQuery("from " + table + " where ps = :ps and pid = :pid and actionName = :actionName");
        q.setEntity("ps", (Object)scheme);
        q.setString("pid", pid);
        q.setString("actionName", actionName);
        return q.uniqueResult();
    }

    public static Set<Project> getProjectsPrincipalCanDoActionIn(Principal principal, String actionName, GroupManager groupManager) {
        HashSet<Project> results = new HashSet<Project>();
        if (principal.equals(Principal.Anonymous.ANON)) {
            results.addAll(PermissionManager.checkForActionInAnyScheme(PrincipalAssocs.AnonymousPA.toString(), actionName));
            return results;
        }
        results.addAll(PermissionManager.checkForActionInAnyScheme(PrincipalAssocs.AllUserPA.toString(), actionName));
        results.addAll(PermissionManager.checkForActionInAnyScheme(PrincipalAssocs.UserPA.toString(), principal.getUserName(), actionName));
        try {
            List<String> groups = groupManager.getPrincipalGroups(principal);
            if (groups != null) {
                for (String group : groups) {
                    results.addAll(PermissionManager.checkForActionInAnyScheme(PrincipalAssocs.GroupPA.toString(), group, actionName));
                }
            }
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"Problem looking up groups, group based permission skipped (denied).", (Throwable)e2);
        }
        return results;
    }

    public static boolean canPrincipalDoActionInAnyProject(Principal principal, String actionName, GroupManager groupManager) {
        if (principal.equals(Principal.Anonymous.ANON)) {
            return !PermissionManager.checkForActionInAnyScheme(PrincipalAssocs.AnonymousPA.toString(), actionName).isEmpty();
        }
        if (!PermissionManager.nullOrEmpty(PermissionManager.checkForActionInAnyScheme(PrincipalAssocs.AllUserPA.toString(), actionName))) {
            return true;
        }
        if (!PermissionManager.nullOrEmpty(PermissionManager.checkForActionInAnyScheme(PrincipalAssocs.UserPA.toString(), principal.getUserName(), actionName))) {
            return true;
        }
        try {
            List<String> groups = groupManager.getPrincipalGroups(principal);
            if (groups != null) {
                for (String group : groups) {
                    if (PermissionManager.nullOrEmpty(PermissionManager.checkForActionInAnyScheme(PrincipalAssocs.GroupPA.toString(), group, actionName))) continue;
                    return true;
                }
            }
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"Problem looking up groups, group based permission skipped (denied).", (Throwable)e2);
        }
        return false;
    }

    private static boolean nullOrEmpty(List l) {
        return l == null || l.isEmpty();
    }

    private static List<Project> checkForActionInAnyScheme(String table, String actionName) {
        Query q = PermissionManager.session().createQuery("select proj from Project proj, " + table + " pa " + "where pa.actionName = :actionName " + "and proj.permissionScheme = pa.ps");
        q.setString("actionName", actionName);
        return q.list();
    }

    private static List<Project> checkForActionInAnyScheme(String table, String pid, String actionName) {
        Query q = PermissionManager.session().createQuery("select proj from Project proj, " + table + " pa " + " where pa.pid = :pid and pa.actionName = :actionName and proj.permissionScheme = pa.ps");
        q.setString("pid", pid);
        q.setString("actionName", actionName);
        return q.list();
    }

    public static PermissionScheme getDefaultPermissionScheme() {
        return (PermissionScheme)PermissionManager.session().get(PermissionScheme.class, (Serializable)Integer.valueOf(1));
    }

    public static PermissionScheme createDefaultPS() {
        PermissionScheme ps = PermissionManager.getDefaultPermissionScheme();
        if (ps == null) {
            ps = new PermissionScheme(DEFAULT_PS_NAME);
            ps.setId(1);
            PermissionManager.session().save((Object)ps);
        }
        return ps;
    }

    public static PermissionScheme copyPermissionScheme(PermissionScheme ps, String name) {
        PermissionScheme newPS = PermissionManager.createPS(name);
        for (AllUserPA allUserPA : ps.getAllUsersPAs()) {
            newPS.addAllUsersAction(allUserPA.getActionName());
        }
        for (AnonymousPA anonymousPA : ps.getAnonymousPAs()) {
            newPS.addAnonAction(anonymousPA.getActionName());
        }
        for (UserPA userPA : ps.getUserPAs()) {
            newPS.addUserAction(userPA.getPid(), userPA.getActionName());
        }
        for (GroupPA groupPA : ps.getGroupPAs()) {
            newPS.addGroupAction(groupPA.getPid(), groupPA.getActionName());
        }
        for (RolePA rolePA : ps.getReviewRolePAs()) {
            newPS.addReviewRoleAction(rolePA.getPid(), rolePA.getActionName());
        }
        return newPS;
    }

    public static void deletePermissionScheme(PermissionScheme ps) {
        PermissionManager.session().createQuery("delete AllUserPA where ps = :ps").setEntity("ps", (Object)ps).executeUpdate();
        PermissionManager.session().createQuery("delete AnonymousPA where ps = :ps").setEntity("ps", (Object)ps).executeUpdate();
        PermissionManager.session().createQuery("delete UserPA where ps = :ps").setEntity("ps", (Object)ps).executeUpdate();
        PermissionManager.session().createQuery("delete GroupPA where ps = :ps").setEntity("ps", (Object)ps).executeUpdate();
        PermissionManager.session().createQuery("delete RolePA where ps = :ps").setEntity("ps", (Object)ps).executeUpdate();
        PermissionManager.delete(ps);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PrincipalAssocs {
        AnonymousPA,
        AllUserPA,
        UserPA,
        GroupPA,
        RolePA;

    }
}

